/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.listener;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.hooks.PluginHooks;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.listener.protocollib.ProtocolLibService;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.SpawnLoader;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;

public class ServerListener
implements Listener {
    @Inject
    private PluginHooks pluginHooks;
    @Inject
    private SpawnLoader spawnLoader;
    @Inject
    private ProtocolLibService protocolLibService;
    @Inject
    private PermissionsManager permissionsManager;

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPluginDisable(PluginDisableEvent event) {
        if (event.getPlugin() == null) {
            return;
        }
        String pluginName = event.getPlugin().getName();
        this.permissionsManager.onPluginDisable(pluginName);
        if ("Essentials".equalsIgnoreCase(pluginName)) {
            this.pluginHooks.unhookEssentials();
            ConsoleLogger.info("Essentials has been disabled: unhooking");
        } else if ("Multiverse-Core".equalsIgnoreCase(pluginName)) {
            this.pluginHooks.unhookMultiverse();
            ConsoleLogger.info("Multiverse-Core has been disabled: unhooking");
        } else if ("CombatTagPlus".equalsIgnoreCase(pluginName)) {
            this.pluginHooks.unhookCombatPlus();
            ConsoleLogger.info("CombatTagPlus has been disabled: unhooking");
        } else if ("EssentialsSpawn".equalsIgnoreCase(pluginName)) {
            this.spawnLoader.unloadEssentialsSpawn();
            ConsoleLogger.info("EssentialsSpawn has been disabled: unhooking");
        } else if ("ProtocolLib".equalsIgnoreCase(pluginName)) {
            this.protocolLibService.disable();
            ConsoleLogger.warning("ProtocolLib has been disabled, unhooking packet adapters!");
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPluginEnable(PluginEnableEvent event) {
        if (event.getPlugin() == null) {
            return;
        }
        String pluginName = event.getPlugin().getName();
        this.permissionsManager.onPluginEnable(pluginName);
        if ("Essentials".equalsIgnoreCase(pluginName)) {
            this.pluginHooks.tryHookToEssentials();
        } else if ("Multiverse-Core".equalsIgnoreCase(pluginName)) {
            this.pluginHooks.tryHookToMultiverse();
        } else if ("CombatTagPlus".equalsIgnoreCase(pluginName)) {
            this.pluginHooks.tryHookToCombatPlus();
        } else if ("EssentialsSpawn".equalsIgnoreCase(pluginName)) {
            this.spawnLoader.loadEssentialsSpawn();
        } else if ("ProtocolLib".equalsIgnoreCase(pluginName)) {
            this.protocolLibService.setup();
        }
    }
}

