/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.listener;

import fr.xephi.authme.AntiBot;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.listener.FailedVerificationException;
import fr.xephi.authme.listener.ListenerService;
import fr.xephi.authme.listener.OnJoinVerifier;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.output.Messages;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.SpawnLoader;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.TeleportationService;
import fr.xephi.authme.util.ValidationService;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPickupItemEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerShearEntityEvent;

public class PlayerListener
implements Listener {
    public static final ConcurrentHashMap<String, String> joinMessage = new ConcurrentHashMap();
    @Inject
    private Settings settings;
    @Inject
    private Messages m;
    @Inject
    private DataSource dataSource;
    @Inject
    private AntiBot antiBot;
    @Inject
    private Management management;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private SpawnLoader spawnLoader;
    @Inject
    private OnJoinVerifier onJoinVerifier;
    @Inject
    private ListenerService listenerService;
    @Inject
    private TeleportationService teleportationService;
    @Inject
    private ValidationService validationService;

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerCommandPreprocess(PlayerCommandPreprocessEvent event) {
        String cmd = event.getMessage().split(" ")[0].toLowerCase();
        if (this.settings.getProperty(HooksSettings.USE_ESSENTIALS_MOTD).booleanValue() && cmd.equals("/motd")) {
            return;
        }
        if (this.settings.getProperty(RestrictionSettings.ALLOW_COMMANDS).contains(cmd)) {
            return;
        }
        Player player = event.getPlayer();
        if (this.listenerService.shouldCancelEvent(player)) {
            event.setCancelled(true);
            this.m.send((CommandSender)player, MessageKey.DENIED_COMMAND);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (this.settings.getProperty(RestrictionSettings.ALLOW_CHAT).booleanValue()) {
            return;
        }
        Player player = event.getPlayer();
        if (this.listenerService.shouldCancelEvent(player)) {
            event.setCancelled(true);
            this.m.send((CommandSender)player, MessageKey.DENIED_CHAT);
        } else if (this.settings.getProperty(RestrictionSettings.HIDE_CHAT).booleanValue()) {
            Set recipients = event.getRecipients();
            Iterator iter = recipients.iterator();
            while (iter.hasNext()) {
                Player p = (Player)iter.next();
                if (!this.listenerService.shouldCancelEvent(p)) continue;
                iter.remove();
            }
            if (recipients.size() == 0) {
                event.setCancelled(true);
            }
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerMove(PlayerMoveEvent event) {
        if (this.settings.getProperty(RestrictionSettings.ALLOW_UNAUTHED_MOVEMENT).booleanValue() && this.settings.getProperty(RestrictionSettings.ALLOWED_MOVEMENT_RADIUS) <= 0) {
            return;
        }
        Location from = event.getFrom();
        Location to = event.getTo();
        if (from.getBlockX() == to.getBlockX() && from.getBlockZ() == to.getBlockZ() && from.getY() - to.getY() >= 0.0) {
            return;
        }
        Player player = event.getPlayer();
        if (!this.listenerService.shouldCancelEvent(player)) {
            return;
        }
        if (!this.settings.getProperty(RestrictionSettings.ALLOW_UNAUTHED_MOVEMENT).booleanValue()) {
            event.setTo(event.getFrom());
            return;
        }
        if (this.settings.getProperty(RestrictionSettings.NO_TELEPORT).booleanValue()) {
            return;
        }
        Location spawn = this.spawnLoader.getSpawnLocation(player);
        if (spawn != null && spawn.getWorld() != null) {
            if (!player.getWorld().equals(spawn.getWorld())) {
                player.teleport(spawn);
                return;
            }
            if (spawn.distance(player.getLocation()) > (double)this.settings.getProperty(RestrictionSettings.ALLOWED_MOVEMENT_RADIUS).intValue()) {
                player.teleport(spawn);
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onJoinMessage(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (this.settings.getProperty(RegistrationSettings.REMOVE_JOIN_MESSAGE).booleanValue()) {
            event.setJoinMessage(null);
            return;
        }
        if (!this.settings.getProperty(RegistrationSettings.DELAY_JOIN_MESSAGE).booleanValue()) {
            return;
        }
        String name = player.getName().toLowerCase();
        String joinMsg = event.getJoinMessage();
        if (joinMsg != null) {
            event.setJoinMessage(null);
            joinMessage.put(name, joinMsg);
        }
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onPlayerJoin(PlayerJoinEvent event) {
        Player player = event.getPlayer();
        this.teleportationService.teleportNewPlayerToFirstSpawn(player);
        this.management.performJoin(player);
    }

    @EventHandler(priority=EventPriority.LOW)
    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        String name = player.getName();
        if (this.validationService.isUnrestricted(name)) {
            return;
        }
        if (this.onJoinVerifier.refusePlayerForFullServer(event)) {
            return;
        }
        if (event.getResult() != PlayerLoginEvent.Result.ALLOWED) {
            return;
        }
        try {
            this.onJoinVerifier.checkSingleSession(name);
            this.onJoinVerifier.checkIsValidName(name);
            PlayerAuth auth = this.dataSource.getAuth(name);
            boolean isAuthAvailable = auth != null;
            String lowerName = name.toLowerCase();
            this.onJoinVerifier.checkAntibot(lowerName, isAuthAvailable);
            this.onJoinVerifier.checkKickNonRegistered(isAuthAvailable);
            this.onJoinVerifier.checkNameCasing(player, auth);
            this.onJoinVerifier.checkPlayerCountry(isAuthAvailable, event.getAddress().getHostAddress());
        }
        catch (FailedVerificationException e) {
            event.setKickMessage(this.m.retrieveSingle(e.getReason(), e.getArgs()));
            event.setResult(PlayerLoginEvent.Result.KICK_OTHER);
            return;
        }
        this.antiBot.handlePlayerJoin(player);
        this.teleportationService.teleportOnJoin(player);
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        if (this.settings.getProperty(RegistrationSettings.REMOVE_LEAVE_MESSAGE).booleanValue()) {
            event.setQuitMessage(null);
        } else if (this.settings.getProperty(RegistrationSettings.REMOVE_UNLOGGED_LEAVE_MESSAGE).booleanValue() && this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setQuitMessage(null);
        }
        if (this.antiBot.wasPlayerKicked(player.getName())) {
            return;
        }
        this.management.performQuit(player);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerKick(PlayerKickEvent event) {
        if (this.settings.getProperty(RestrictionSettings.FORCE_SINGLE_SESSION).booleanValue() && event.getReason().contains("You logged in from another location")) {
            event.setCancelled(true);
            return;
        }
        Player player = event.getPlayer();
        if (!this.antiBot.wasPlayerKicked(player.getName())) {
            this.management.performQuit(player);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerPickupItem(PlayerPickupItemEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteract(PlayerInteractEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerConsumeItem(PlayerItemConsumeEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInventoryOpen(InventoryOpenEvent event) {
        final Player player = (Player)event.getPlayer();
        if (!this.listenerService.shouldCancelEvent(player)) {
            return;
        }
        event.setCancelled(true);
        this.bukkitService.scheduleSyncDelayedTask(new Runnable(){

            @Override
            public void run() {
                player.closeInventory();
            }
        }, 1L);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInventoryClick(InventoryClickEvent event) {
        if (event.getWhoClicked() == null) {
            return;
        }
        if (!(event.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        if (!this.listenerService.shouldCancelEvent(player)) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerHitPlayerEvent(EntityDamageByEntityEvent event) {
        if (this.listenerService.shouldCancelEvent((EntityEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerDropItem(PlayerDropItemEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerBedEnter(PlayerBedEnterEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onSignChange(SignChangeEvent event) {
        Player player = event.getPlayer();
        if (this.listenerService.shouldCancelEvent(player)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onPlayerRespawn(PlayerRespawnEvent event) {
        if (this.settings.getProperty(RestrictionSettings.NO_TELEPORT).booleanValue()) {
            return;
        }
        if (!this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            return;
        }
        Player player = event.getPlayer();
        String name = player.getName().toLowerCase();
        Location spawn = this.spawnLoader.getSpawnLocation(player);
        if (this.settings.getProperty(RestrictionSettings.SAVE_QUIT_LOCATION).booleanValue() && this.dataSource.isAuthAvailable(name)) {
            PlayerAuth auth = PlayerAuth.builder().name(name).realName(player.getName()).location(spawn).build();
            this.dataSource.updateQuitLoc(auth);
        }
        if (spawn != null && spawn.getWorld() != null) {
            event.setRespawnLocation(spawn);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerShear(PlayerShearEntityEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.LOWEST)
    public void onPlayerFish(PlayerFishEvent event) {
        if (this.listenerService.shouldCancelEvent((PlayerEvent)event)) {
            event.setCancelled(true);
        }
    }
}

