/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.zaxxer.hikari.util;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public interface Sequence {
    public void increment();

    public long get();

    public static final class Java8Sequence
    extends LongAdder
    implements Sequence {
        @Override
        public long get() {
            return this.sum();
        }
    }

    public static final class Java7Sequence
    extends AtomicLong
    implements Sequence {
        @Override
        public void increment() {
            this.incrementAndGet();
        }
    }

    public static final class Factory {
        public static Sequence create() {
            if (!Boolean.getBoolean("fr.xephi.authme.libs.zaxxer.hikari.useAtomicLongSequence")) {
                return new Java8Sequence();
            }
            return new Java7Sequence();
        }
    }
}

