/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.jalu.injector.testing.runner;

import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.jalu.injector.handlers.dependency.DependencyHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.DependencyDescription;
import fr.xephi.authme.libs.jalu.injector.testing.InjectDelayed;
import fr.xephi.authme.libs.jalu.injector.utils.ReflectionUtils;
import java.util.HashSet;
import java.util.Set;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.TestClass;
import org.mockito.Mock;

public class MockDependencyHandler
implements DependencyHandler {
    private final TestClass testClass;
    private final Object target;
    private boolean areMocksRegistered;
    private Set<Class<?>> fieldsToInject;

    public MockDependencyHandler(TestClass testClass, Object target) {
        this.testClass = testClass;
        this.target = target;
    }

    @Override
    public Object resolveValue(Injector injector, DependencyDescription dependencyDescription) throws Exception {
        Class<?> type;
        Object object;
        if (!this.areMocksRegistered) {
            this.registerAllMocks(injector);
            this.areMocksRegistered = true;
        }
        if ((object = injector.getIfAvailable(type = dependencyDescription.getType())) != null) {
            return object;
        }
        if (this.fieldsToInject.contains(type)) {
            return null;
        }
        throw new IllegalStateException("No mock found for '" + type + "'. " + "All dependencies of @InjectDelayed must be provided as @Mock or @InjectDelayed fields");
    }

    private void registerAllMocks(Injector injector) {
        for (FrameworkField frameworkField : this.testClass.getAnnotatedFields(Mock.class)) {
            Class clazz = frameworkField.getType();
            injector.register(clazz, ReflectionUtils.getFieldValue(frameworkField.getField(), this.target));
        }
        this.fieldsToInject = new HashSet();
        for (FrameworkField frameworkField : this.testClass.getAnnotatedFields(InjectDelayed.class)) {
            this.fieldsToInject.add(frameworkField.getType());
        }
    }
}

