/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.jalu.injector.testing.runner;

import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.jalu.injector.handlers.dependency.DependencyHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.DependencyDescription;
import fr.xephi.authme.libs.jalu.injector.testing.InjectDelayed;
import fr.xephi.authme.libs.jalu.injector.utils.ReflectionUtils;
import fr.xephi.authme.libs.javax.inject.Inject;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.TestClass;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Spy;

public class AnnotationResolver
implements DependencyHandler {
    private final TestClass testClass;
    private final Object target;
    private final Set<Class<? extends Annotation>> ignoredAnnotations;

    public AnnotationResolver(TestClass testClass, Object target) {
        this(testClass, target, Inject.class, InjectMocks.class, Mock.class, Spy.class, InjectDelayed.class);
    }

    @SafeVarargs
    public AnnotationResolver(TestClass testClass, Object target, Class<? extends Annotation> ... ignoredAnnotations) {
        this.testClass = testClass;
        this.target = target;
        this.ignoredAnnotations = Collections.unmodifiableSet(new HashSet<Class<? extends Annotation>>(Arrays.asList(ignoredAnnotations)));
    }

    @Override
    public Object resolveValue(Injector injector, DependencyDescription dependencyDescription) throws Exception {
        for (Annotation annotation : dependencyDescription.getAnnotations()) {
            Object o = this.resolveByAnnotation(annotation.annotationType(), dependencyDescription.getType());
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Nullable
    private Object resolveByAnnotation(Class<? extends Annotation> annotation, Class<?> type) {
        if (!this.ignoredAnnotations.contains(annotation)) {
            List fields = this.testClass.getAnnotatedFields(annotation);
            for (FrameworkField field : fields) {
                if (!type.isAssignableFrom(field.getType())) continue;
                return ReflectionUtils.getFieldValue(field.getField(), this.target);
            }
        }
        return null;
    }
}

