/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.jalu.injector.handlers.provider;

import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.jalu.injector.exceptions.InjectorException;
import fr.xephi.authme.libs.jalu.injector.handlers.dependency.DependencyHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.DependencyDescription;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.Instantiation;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.InstantiationProvider;
import fr.xephi.authme.libs.jalu.injector.handlers.provider.ProviderHandler;
import fr.xephi.authme.libs.jalu.injector.utils.InjectorUtils;
import fr.xephi.authme.libs.jalu.injector.utils.ReflectionUtils;
import fr.xephi.authme.libs.javax.inject.Provider;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProviderHandlerImpl
implements ProviderHandler,
InstantiationProvider,
DependencyHandler {
    protected Map<Class<?>, ProviderWrappedInstantiation<?>> providers = new HashMap();

    @Override
    public <T> void onProvider(Class<T> clazz, Provider<? extends T> provider) {
        InjectorUtils.checkArgument(!this.providers.containsKey(clazz), "Provider already registered for " + clazz);
        this.providers.put(clazz, new ProviderInstantiation<T>(provider));
    }

    @Override
    public <T, P extends Provider<? extends T>> void onProviderClass(Class<T> clazz, Class<P> providerClass) {
        InjectorUtils.checkArgument(!this.providers.containsKey(clazz), "Provider already registered for " + clazz);
        this.providers.put(clazz, new UninitializedProviderInstantiation<T>(clazz, providerClass));
    }

    @Override
    public <T> Instantiation<T> get(Class<T> clazz) {
        return this.providers.get(clazz);
    }

    @Override
    public Object resolveValue(Injector injector, DependencyDescription dependencyDescription) {
        if (dependencyDescription.getType() == Provider.class) {
            Class<?> genericType = ReflectionUtils.getGenericType(dependencyDescription.getGenericType());
            if (genericType == null) {
                throw new InjectorException("Injection of a provider was requested but no generic type was given");
            }
            ProviderWrappedInstantiation<?> instantiation = this.providers.get(genericType);
            if (instantiation != null) {
                return instantiation.getProvider(injector);
            }
            return ProviderHandlerImpl.constructStandardProvider(genericType, injector);
        }
        return null;
    }

    private static <T> Provider<T> constructStandardProvider(final Class<T> genericType, final Injector injector) {
        return new Provider<T>(){

            @Override
            public T get() {
                return injector.newInstance(genericType);
            }
        };
    }

    private <T> void saveConstructedProvider(Class<T> clazz, Provider<? extends T> provider) {
        this.providers.put(clazz, new ProviderInstantiation<T>(provider));
    }

    private final class UninitializedProviderInstantiation<T>
    implements ProviderWrappedInstantiation<T> {
        private final Class<T> clazz;
        private final Class<? extends Provider<? extends T>> providerClass;

        UninitializedProviderInstantiation(Class<T> clazz, Class<? extends Provider<? extends T>> providerClass) {
            this.providerClass = providerClass;
            this.clazz = clazz;
        }

        @Override
        public List<DependencyDescription> getDependencies() {
            return Collections.singletonList(new DependencyDescription(this.providerClass, this.clazz, new Annotation[0]));
        }

        @Override
        public T instantiateWith(Object ... values) {
            if (values.length == 1 && values[0] instanceof Provider) {
                Provider provider = (Provider)values[0];
                Object object = provider.get();
                ProviderHandlerImpl.this.saveConstructedProvider(this.clazz, provider);
                return object;
            }
            throw new InjectorException("Provider is required as argument");
        }

        @Override
        public Provider<? extends T> getProvider(Injector injector) {
            Provider<? extends T> provider = injector.getSingleton(this.providerClass);
            ProviderHandlerImpl.this.saveConstructedProvider(this.clazz, provider);
            return provider;
        }
    }

    private static final class ProviderInstantiation<T>
    implements ProviderWrappedInstantiation<T> {
        private final Provider<? extends T> provider;

        ProviderInstantiation(Provider<? extends T> provider) {
            this.provider = provider;
        }

        @Override
        public List<DependencyDescription> getDependencies() {
            return Collections.emptyList();
        }

        @Override
        public T instantiateWith(Object ... values) {
            return this.provider.get();
        }

        @Override
        public Provider<? extends T> getProvider(Injector injector) {
            return this.provider;
        }
    }

    private static interface ProviderWrappedInstantiation<T>
    extends Instantiation<T> {
        public Provider<? extends T> getProvider(Injector var1);
    }
}

