/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.jalu.injector.handlers.preconstruct;

import fr.xephi.authme.libs.jalu.injector.exceptions.InjectorException;
import fr.xephi.authme.libs.jalu.injector.handlers.preconstruct.PlainPreConstructHandler;

public class PreConstructPackageValidator
extends PlainPreConstructHandler {
    private final String rootPackage;

    public PreConstructPackageValidator(String rootPackage) {
        this.rootPackage = rootPackage;
    }

    @Override
    public void process(Class<?> clazz) {
        if (clazz.getPackage() == null) {
            String detail = clazz.isPrimitive() ? "Primitive types must be provided explicitly (or use an annotation)." : (clazz.isArray() ? "Unknown how to inject array classes (did you forget to add a custom handler?)" : "");
            throw new InjectorException("Cannot instantiate '" + clazz + "'. " + detail);
        }
        String packageName = clazz.getPackage().getName();
        if (!packageName.startsWith(this.rootPackage)) {
            throw new InjectorException("Class '" + clazz + "' with package '" + packageName + "' is outside of the " + "allowed packages. It must be provided explicitly or the package must be passed to the constructor.");
        }
    }
}

