/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.jalu.injector.handlers.postconstruct;

import fr.xephi.authme.libs.jalu.injector.exceptions.InjectorException;
import fr.xephi.authme.libs.jalu.injector.handlers.postconstruct.PostConstructHandler;
import fr.xephi.authme.libs.jalu.injector.utils.ReflectionUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.PostConstruct;

public class PostConstructMethodInvoker
implements PostConstructHandler {
    @Override
    public <T> T process(T object) {
        for (Class<?> clazz = object.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Method postConstructMethod = PostConstructMethodInvoker.getAndValidatePostConstructMethod(clazz);
            if (postConstructMethod == null) continue;
            ReflectionUtils.invokeMethod(postConstructMethod, object, new Object[0]);
        }
        return null;
    }

    private static Method getAndValidatePostConstructMethod(Class<?> clazz) {
        Method postConstructMethod = null;
        for (Method method : ReflectionUtils.safeGetDeclaredMethods(clazz)) {
            if (!method.isAnnotationPresent(PostConstruct.class)) continue;
            if (postConstructMethod != null) {
                throw new InjectorException("Multiple methods with @PostConstruct on " + clazz);
            }
            if (method.getParameterTypes().length > 0 || Modifier.isStatic(method.getModifiers())) {
                throw new InjectorException("@PostConstruct method may not be static or have any parameters. Invalid method in " + clazz);
            }
            if (method.getReturnType() != Void.TYPE) {
                throw new InjectorException("@PostConstruct method must have return type void. Offending class: " + clazz);
            }
            postConstructMethod = method;
        }
        return postConstructMethod;
    }
}

