/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.jalu.injector.handlers.instantiation;

import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.DependencyDescription;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.Instantiation;
import fr.xephi.authme.libs.jalu.injector.utils.InjectorUtils;
import fr.xephi.authme.libs.jalu.injector.utils.ReflectionUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class FieldInjection<T>
implements Instantiation<T> {
    private final Field[] fields;
    private final Constructor<T> defaultConstructor;

    protected FieldInjection(Constructor<T> defaultConstructor, Collection<Field> fields) {
        this.fields = fields.toArray(new Field[fields.size()]);
        this.defaultConstructor = defaultConstructor;
    }

    @Override
    public List<DependencyDescription> getDependencies() {
        ArrayList<DependencyDescription> dependencies = new ArrayList<DependencyDescription>(this.fields.length);
        for (Field field : this.fields) {
            dependencies.add(new DependencyDescription(field.getType(), field.getGenericType(), field.getAnnotations()));
        }
        return dependencies;
    }

    @Override
    public T instantiateWith(Object ... values) {
        InjectorUtils.checkNoNullValues(values);
        InjectorUtils.checkArgument(values.length == this.fields.length, "The number of values must be equal to the number of fields (class " + InjectorUtils.getDeclarer(this.defaultConstructor) + ")");
        T instance = ReflectionUtils.newInstance(this.defaultConstructor, new Object[0]);
        for (int i = 0; i < this.fields.length; ++i) {
            ReflectionUtils.setField(this.fields[i], instance, values[i]);
        }
        return instance;
    }
}

