/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.jalu.injector.handlers.instantiation;

import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.DependencyDescription;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.Instantiation;
import fr.xephi.authme.libs.jalu.injector.utils.InjectorUtils;
import fr.xephi.authme.libs.jalu.injector.utils.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class ConstructorInjection<T>
implements Instantiation<T> {
    private final Constructor<T> constructor;

    protected ConstructorInjection(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    @Override
    public List<DependencyDescription> getDependencies() {
        Class<?>[] parameters = this.constructor.getParameterTypes();
        Type[] genericTypes = this.constructor.getGenericParameterTypes();
        Annotation[][] annotations = this.constructor.getParameterAnnotations();
        ArrayList<DependencyDescription> dependencies = new ArrayList<DependencyDescription>(parameters.length);
        for (int i = 0; i < parameters.length; ++i) {
            dependencies.add(new DependencyDescription(parameters[i], genericTypes[i], annotations[i]));
        }
        return dependencies;
    }

    @Override
    public T instantiateWith(Object ... values) {
        InjectorUtils.checkNoNullValues(values);
        return ReflectionUtils.newInstance(this.constructor, values);
    }
}

