/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.jalu.injector.handlers.dependency;

import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.jalu.injector.exceptions.InjectorException;
import fr.xephi.authme.libs.jalu.injector.handlers.annotationvalues.AnnotationValueHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.dependency.DependencyHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.DependencyDescription;
import fr.xephi.authme.libs.jalu.injector.utils.InjectorUtils;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;

public class SavedAnnotationsHandler
implements DependencyHandler,
AnnotationValueHandler {
    private Map<Class<?>, Object> storedValues = new HashMap();

    @Override
    public Object resolveValue(Injector injector, DependencyDescription dependencyDescription) {
        for (Annotation annotation : dependencyDescription.getAnnotations()) {
            Object o = this.storedValues.get(annotation.annotationType());
            if (o == null) continue;
            return o;
        }
        return null;
    }

    @Override
    public void processProvided(Class<? extends Annotation> annotation, Object object) {
        InjectorUtils.checkNotNull(object, "Object may not be null");
        if (this.storedValues.containsKey(annotation)) {
            throw new InjectorException("Value already registered for @" + annotation.getSimpleName());
        }
        this.storedValues.put(annotation, object);
    }
}

