/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.jalu.injector;

import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.jalu.injector.InjectorConfig;
import fr.xephi.authme.libs.jalu.injector.InjectorImpl;
import fr.xephi.authme.libs.jalu.injector.exceptions.InjectorException;
import fr.xephi.authme.libs.jalu.injector.handlers.Handler;
import fr.xephi.authme.libs.jalu.injector.handlers.annotationvalues.AnnotationValueHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.dependency.DependencyHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.dependency.SavedAnnotationsHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.ConstructorInjectionProvider;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.FieldInjectionProvider;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.InstantiationFallbackProvider;
import fr.xephi.authme.libs.jalu.injector.handlers.instantiation.InstantiationProvider;
import fr.xephi.authme.libs.jalu.injector.handlers.postconstruct.PostConstructHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.postconstruct.PostConstructMethodInvoker;
import fr.xephi.authme.libs.jalu.injector.handlers.preconstruct.PreConstructHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.preconstruct.PreConstructPackageValidator;
import fr.xephi.authme.libs.jalu.injector.handlers.provider.ProviderHandler;
import fr.xephi.authme.libs.jalu.injector.handlers.provider.ProviderHandlerImpl;
import fr.xephi.authme.libs.jalu.injector.utils.InjectorUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class InjectorBuilder {
    private InjectorConfig config = new InjectorConfig();

    public static List<Handler> createDefaultHandlers(String rootPackage) {
        InjectorUtils.checkNotNull(rootPackage, "root package may not be null");
        return new ArrayList<Handler>(Arrays.asList(new PreConstructPackageValidator(rootPackage), new SavedAnnotationsHandler(), new ProviderHandlerImpl(), new ConstructorInjectionProvider(), new FieldInjectionProvider(), new InstantiationFallbackProvider(), new PostConstructMethodInvoker()));
    }

    public static List<InstantiationProvider> createInstantiationProviders() {
        return new ArrayList<InstantiationProvider>(Arrays.asList(new ProviderHandlerImpl(), new ConstructorInjectionProvider(), new FieldInjectionProvider(), new InstantiationFallbackProvider()));
    }

    public InjectorBuilder addDefaultHandlers(String rootPackage) {
        return this.addHandlers(InjectorBuilder.createDefaultHandlers(rootPackage));
    }

    public InjectorBuilder addHandlers(Handler ... handlers) {
        return this.addHandlers(Arrays.asList(handlers));
    }

    public InjectorBuilder addHandlers(Iterable<? extends Handler> handlers) {
        HandlerCollector collector = new HandlerCollector(AnnotationValueHandler.class, ProviderHandler.class, PreConstructHandler.class, InstantiationProvider.class, DependencyHandler.class, PostConstructHandler.class);
        for (Handler handler : handlers) {
            collector.process(handler);
        }
        this.config.addAnnotationValueHandlers(collector.getList(AnnotationValueHandler.class));
        this.config.addProviderHandlers(collector.getList(ProviderHandler.class));
        this.config.addPreConstructHandlers(collector.getList(PreConstructHandler.class));
        this.config.addInstantiationProviders(collector.getList(InstantiationProvider.class));
        this.config.addDependencyHandlers(collector.getList(DependencyHandler.class));
        this.config.addPostConstructHandlers(collector.getList(PostConstructHandler.class));
        return this;
    }

    public Injector create() {
        return new InjectorImpl(this.config);
    }

    private static final class HandlerCollector {
        private final Map<Class<? extends Handler>, List<? extends Handler>> handlersByType = new HashMap<Class<? extends Handler>, List<? extends Handler>>();
        private final Class<? extends Handler>[] subtypes;

        @SafeVarargs
        public HandlerCollector(Class<? extends Handler> ... subtypes) {
            this.subtypes = subtypes;
            for (Class<? extends Handler> subtype : subtypes) {
                this.handlersByType.put(subtype, new ArrayList());
            }
        }

        public void process(Handler handler) {
            boolean foundSubtype = false;
            for (Class<? extends Handler> subtype : this.subtypes) {
                foundSubtype |= this.addHandler(subtype, handler);
            }
            if (!foundSubtype) {
                throw new InjectorException(String.format("Class '%s' must extend a known Handler subtype", handler.getClass().getName()));
            }
        }

        public <T extends Handler> List<T> getList(Class<T> clazz) {
            return this.handlersByType.get(clazz);
        }

        private <T extends Handler> boolean addHandler(Class<T> clazz, Handler handler) {
            if (clazz.isInstance(handler)) {
                this.getList(clazz).add(handler);
                return true;
            }
            return false;
        }
    }
}

