/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.authme.configme.resource;

import fr.xephi.authme.libs.authme.configme.exception.ConfigMeException;
import fr.xephi.authme.libs.authme.configme.knownproperties.PropertyEntry;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.authme.configme.properties.StringListProperty;
import fr.xephi.authme.libs.authme.configme.resource.PropertyResource;
import fr.xephi.authme.libs.authme.configme.resource.YamlFileReader;
import fr.xephi.authme.libs.authme.configme.utils.CollectionUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class YamlFileResource
implements PropertyResource {
    private static final String INDENTATION = "    ";
    private final File file;
    private YamlFileReader reader;
    private Yaml simpleYaml;
    private Yaml singleQuoteYaml;

    public YamlFileResource(File file) {
        this.file = file;
        this.reader = new YamlFileReader(file);
    }

    @Override
    public Object getObject(String path) {
        return this.reader.getObject(path);
    }

    @Override
    public String getString(String path) {
        return this.reader.getTypedObject(path, String.class);
    }

    @Override
    public Integer getInt(String path) {
        Number n = this.reader.getTypedObject(path, Number.class);
        return n == null ? null : Integer.valueOf(n.intValue());
    }

    @Override
    public Double getDouble(String path) {
        Number n = this.reader.getTypedObject(path, Number.class);
        return n == null ? null : Double.valueOf(n.doubleValue());
    }

    @Override
    public Boolean getBoolean(String path) {
        return this.reader.getTypedObject(path, Boolean.class);
    }

    @Override
    public List<?> getList(String path) {
        return this.reader.getTypedObject(path, List.class);
    }

    @Override
    public boolean contains(String path) {
        return this.reader.getObject(path) != null;
    }

    @Override
    public void setValue(String path, Object value) {
        this.reader.set(path, value);
    }

    @Override
    public void reload() {
        this.reader = new YamlFileReader(this.file);
    }

    @Override
    public void exportProperties(List<PropertyEntry> knownProperties) {
        try (FileWriter writer = new FileWriter(this.file);){
            writer.write("");
            List<Object> currentPath = new ArrayList();
            for (PropertyEntry entry : knownProperties) {
                Property<?> property = entry.getProperty();
                List<String> propertyPath = Arrays.asList(property.getPath().split("\\."));
                List<String> commonPathParts = CollectionUtils.filterCommonStart(currentPath, propertyPath.subList(0, propertyPath.size() - 1));
                List<String> newPathParts = CollectionUtils.getRange(propertyPath, commonPathParts.size());
                if (commonPathParts.isEmpty()) {
                    writer.append("\n");
                }
                int indentationLevel = commonPathParts.size();
                if (newPathParts.size() > 1) {
                    for (String path : newPathParts.subList(0, newPathParts.size() - 1)) {
                        writer.append("\n").append(YamlFileResource.indent(indentationLevel)).append(path).append(": ");
                        ++indentationLevel;
                    }
                }
                for (String comment : entry.getComments()) {
                    writer.append("\n").append(YamlFileResource.indent(indentationLevel)).append("# ").append(comment);
                }
                writer.append("\n").append(YamlFileResource.indent(indentationLevel)).append(CollectionUtils.getRange(newPathParts, newPathParts.size() - 1).get(0)).append(": ").append(this.toYaml(property, indentationLevel));
                currentPath = propertyPath.subList(0, propertyPath.size() - 1);
            }
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            throw new ConfigMeException("Could not save config to '" + this.file.getPath() + "'", e);
        }
        finally {
            this.simpleYaml = null;
            this.singleQuoteYaml = null;
        }
    }

    protected String transformValue(Property<?> property, Object value) {
        if (property instanceof StringListProperty) {
            String representation = this.getSingleQuoteYaml().dump(value);
            return ((Collection)value).isEmpty() ? representation : "\n" + representation;
        }
        if (value instanceof Enum) {
            return this.getSingleQuoteYaml().dump((Object)((Enum)value).name());
        }
        if (value instanceof String) {
            return this.getSingleQuoteYaml().dump(value);
        }
        return this.getSimpleYaml().dump(value);
    }

    private <T> String toYaml(Property<T> property, int indent) {
        T value = property.getValue(this);
        String representation = this.transformValue(property, value);
        String result = "";
        String[] lines = representation.split("\\n");
        for (int i = 0; i < lines.length; ++i) {
            result = i == 0 ? lines[0] : result + "\n" + YamlFileResource.indent(indent) + lines[i];
        }
        return result;
    }

    private static String indent(int level) {
        String result = "";
        for (int i = 0; i < level; ++i) {
            result = result + INDENTATION;
        }
        return result;
    }

    protected Yaml getSimpleYaml() {
        if (this.simpleYaml == null) {
            this.simpleYaml = YamlFileResource.newYaml(false);
        }
        return this.simpleYaml;
    }

    protected Yaml getSingleQuoteYaml() {
        if (this.singleQuoteYaml == null) {
            this.singleQuoteYaml = YamlFileResource.newYaml(true);
        }
        return this.singleQuoteYaml;
    }

    private static Yaml newYaml(boolean useSingleQuotes) {
        DumperOptions options = new DumperOptions();
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        options.setAllowUnicode(true);
        if (useSingleQuotes) {
            options.setDefaultScalarStyle(DumperOptions.ScalarStyle.SINGLE_QUOTED);
        }
        return new Yaml(options);
    }
}

