/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.authme.configme.resource;

import fr.xephi.authme.libs.authme.configme.exception.ConfigMeException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.yaml.snakeyaml.Yaml;

public class YamlFileReader {
    private Map<String, Object> root;

    public YamlFileReader(File file) {
        try (FileInputStream fis = new FileInputStream(file);){
            Object obj = new Yaml().load((InputStream)fis);
            this.root = (Map)obj;
        }
        catch (IOException e) {
            throw new ConfigMeException("Could not read file '" + file + "'", e);
        }
        catch (ClassCastException e) {
            throw new ConfigMeException("Top-level is not a map in '" + file + "'", e);
        }
    }

    public Object getObject(String path) {
        String[] keys;
        Object node = this.root;
        for (String key : keys = path.split("\\.")) {
            if ((node = YamlFileReader.getIfIsMap(key, node)) != null) continue;
            return null;
        }
        return node;
    }

    public <T> T getTypedObject(String path, Class<T> clazz) {
        Object value = this.getObject(path);
        if (clazz.isInstance(value)) {
            return clazz.cast(value);
        }
        return null;
    }

    public void set(String path, Object value) {
        Objects.requireNonNull(path);
        Objects.requireNonNull(value);
        HashMap<String, Object> node = this.root;
        String[] keys = path.split("\\.");
        for (int i = 0; i < keys.length - 1; ++i) {
            Object child = node.get(keys[i]);
            if (child instanceof Map) {
                node = (HashMap<String, Object>)child;
                continue;
            }
            HashMap<String, Object> newEntry = new HashMap<String, Object>();
            node.put(keys[i], newEntry);
            node = newEntry;
        }
        node.put(keys[keys.length - 1], value);
    }

    private static Object getIfIsMap(String key, Object value) {
        if (value instanceof Map) {
            return ((Map)value).get(key);
        }
        return null;
    }
}

