/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.authme.configme.knownproperties;

import fr.xephi.authme.libs.authme.configme.Comment;
import fr.xephi.authme.libs.authme.configme.SettingsHolder;
import fr.xephi.authme.libs.authme.configme.exception.ConfigMeException;
import fr.xephi.authme.libs.authme.configme.knownproperties.KnownPropertiesBuilder;
import fr.xephi.authme.libs.authme.configme.knownproperties.PropertyEntry;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.List;
import javax.annotation.Nullable;

public class PropertyFieldsCollector {
    private PropertyFieldsCollector() {
    }

    @SafeVarargs
    public static List<PropertyEntry> getAllProperties(Class<? extends SettingsHolder> ... classes) {
        KnownPropertiesBuilder propertyListBuilder = new KnownPropertiesBuilder();
        for (Class<? extends SettingsHolder> clazz : classes) {
            Field[] declaredFields;
            for (Field field : declaredFields = clazz.getDeclaredFields()) {
                Property<?> property = PropertyFieldsCollector.getPropertyField(field);
                if (property == null) continue;
                propertyListBuilder.add(property, PropertyFieldsCollector.getCommentsForField(field));
            }
        }
        return propertyListBuilder.create();
    }

    private static String[] getCommentsForField(Field field) {
        if (field.isAnnotationPresent(Comment.class)) {
            return field.getAnnotation(Comment.class).value();
        }
        return new String[0];
    }

    @Nullable
    private static Property<?> getPropertyField(Field field) {
        field.setAccessible(true);
        if (field.isAccessible() && Property.class.equals(field.getType()) && Modifier.isStatic(field.getModifiers())) {
            try {
                return (Property)field.get(null);
            }
            catch (IllegalAccessException e) {
                throw new ConfigMeException("Could not fetch field '" + field.getName() + "' from class '" + field.getDeclaringClass().getSimpleName() + "'", e);
            }
        }
        return null;
    }
}

