/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.authme.configme.knownproperties;

import fr.xephi.authme.libs.authme.configme.exception.ConfigMeException;
import fr.xephi.authme.libs.authme.configme.knownproperties.PropertyEntry;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class KnownPropertiesBuilder {
    private Map<String, Object> rootEntries = new LinkedHashMap<String, Object>();

    public void add(Property<?> property, String ... comments) {
        String[] paths = property.getPath().split("\\.");
        Map<String, Object> map = this.rootEntries;
        for (int i = 0; i < paths.length - 1; ++i) {
            map = KnownPropertiesBuilder.getChildMap(map, paths[i]);
        }
        String end = paths[paths.length - 1];
        if (map.containsKey(end)) {
            throw new ConfigMeException("Path at '" + property.getPath() + "' already exists");
        }
        map.put(end, new PropertyEntry(property, comments));
    }

    public List<PropertyEntry> create() {
        ArrayList<PropertyEntry> result = new ArrayList<PropertyEntry>();
        KnownPropertiesBuilder.collectEntries(this.rootEntries, result);
        return result;
    }

    private static Map<String, Object> getChildMap(Map<String, Object> parent, String path) {
        Object o = parent.get(path);
        if (o instanceof Map) {
            return KnownPropertiesBuilder.asTypedMap(o);
        }
        if (o == null) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            parent.put(path, map);
            return map;
        }
        if (o instanceof PropertyEntry) {
            throw new ConfigMeException("Unexpected entry found at path '" + path + "'");
        }
        throw new ConfigMeException("Value of unknown type found at '" + path + "': " + o);
    }

    private static void collectEntries(Map<String, Object> map, List<PropertyEntry> results) {
        for (Object o : map.values()) {
            if (o instanceof Map) {
                KnownPropertiesBuilder.collectEntries(KnownPropertiesBuilder.asTypedMap(o), results);
                continue;
            }
            if (!(o instanceof PropertyEntry)) continue;
            results.add((PropertyEntry)o);
        }
    }

    private static Map<String, Object> asTypedMap(Object o) {
        return (Map)o;
    }
}

