/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.libs.authme.configme;

import fr.xephi.authme.libs.authme.configme.SettingsHolder;
import fr.xephi.authme.libs.authme.configme.knownproperties.PropertyEntry;
import fr.xephi.authme.libs.authme.configme.knownproperties.PropertyFieldsCollector;
import fr.xephi.authme.libs.authme.configme.migration.MigrationService;
import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.authme.configme.resource.PropertyResource;
import java.util.Collections;
import java.util.List;

public class SettingsManager {
    protected final List<PropertyEntry> knownProperties;
    protected final PropertyResource resource;
    protected final MigrationService migrationService;

    @SafeVarargs
    public SettingsManager(PropertyResource resource, MigrationService migrationService, Class<? extends SettingsHolder> ... settingsClasses) {
        this(resource, migrationService, PropertyFieldsCollector.getAllProperties(settingsClasses));
    }

    public SettingsManager(PropertyResource resource, MigrationService migrationService, List<? extends PropertyEntry> knownProperties) {
        this.knownProperties = Collections.unmodifiableList(knownProperties);
        this.resource = resource;
        this.migrationService = migrationService;
        this.validateAndLoadOptions();
    }

    public <T> T getProperty(Property<T> property) {
        return property.getValue(this.resource);
    }

    public <T> void setProperty(Property<T> property, T value) {
        this.resource.setValue(property.getPath(), value);
    }

    public void reload() {
        this.resource.reload();
        this.validateAndLoadOptions();
    }

    public void save() {
        this.resource.exportProperties(this.knownProperties);
    }

    protected void validateAndLoadOptions() {
        if (this.migrationService.checkAndMigrate(this.resource, this.knownProperties)) {
            this.save();
        }
    }
}

