/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.initialization;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.AuthMe;
import fr.xephi.authme.datasource.DataSource;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.scheduler.BukkitScheduler;
import org.bukkit.scheduler.BukkitWorker;

public class TaskCloser
implements Runnable {
    private final BukkitScheduler scheduler;
    private final Logger logger;
    private final AuthMe plugin;
    private final DataSource dataSource;

    public TaskCloser(AuthMe plugin, DataSource dataSource) {
        this.scheduler = plugin.getServer().getScheduler();
        this.logger = plugin.getLogger();
        this.plugin = plugin;
        this.dataSource = dataSource;
    }

    @Override
    public void run() {
        List<Integer> pendingTasks = this.getPendingTasks();
        this.logger.log(Level.INFO, "Waiting for {0} tasks to finish", pendingTasks.size());
        int progress = 0;
        int tries = 60;
        while (!pendingTasks.isEmpty()) {
            if (tries <= 0) {
                this.logger.log(Level.INFO, "Async tasks times out after to many tries {0}", pendingTasks);
                break;
            }
            try {
                this.sleep();
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
                break;
            }
            Iterator<Integer> iterator = pendingTasks.iterator();
            while (iterator.hasNext()) {
                int taskId = iterator.next();
                if (this.scheduler.isCurrentlyRunning(taskId)) continue;
                iterator.remove();
                this.logger.log(Level.INFO, "Progress: {0} / {1}", new Object[]{++progress, pendingTasks.size()});
            }
            --tries;
        }
        if (this.dataSource != null) {
            this.dataSource.close();
        }
    }

    @VisibleForTesting
    void sleep() throws InterruptedException {
        Thread.sleep(1000L);
    }

    private List<Integer> getPendingTasks() {
        ArrayList<Integer> pendingTasks = new ArrayList<Integer>();
        for (BukkitWorker pendingTask : this.scheduler.getActiveWorkers()) {
            if (!pendingTask.getOwner().equals((Object)this.plugin) || this.scheduler.isQueued(pendingTask.getTaskId())) continue;
            pendingTasks.add(pendingTask.getTaskId());
        }
        return pendingTasks;
    }
}

