/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.initialization;

import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.cache.backup.PlayerDataStorage;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.hooks.PluginHooks;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.SpawnLoader;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.ValidationService;
import org.bukkit.Location;
import org.bukkit.entity.Player;

public class OnShutdownPlayerSaver {
    @Inject
    private BukkitService bukkitService;
    @Inject
    private Settings settings;
    @Inject
    private ValidationService validationService;
    @Inject
    private LimboCache limboCache;
    @Inject
    private DataSource dataSource;
    @Inject
    private PlayerDataStorage playerDataStorage;
    @Inject
    private SpawnLoader spawnLoader;
    @Inject
    private PluginHooks pluginHooks;
    @Inject
    private PlayerCache playerCache;

    OnShutdownPlayerSaver() {
    }

    public void saveAllPlayers() {
        for (Player player : this.bukkitService.getOnlinePlayers()) {
            this.savePlayer(player);
        }
    }

    private void savePlayer(Player player) {
        String name = player.getName().toLowerCase();
        if (this.pluginHooks.isNpc(player) || this.validationService.isUnrestricted(name)) {
            return;
        }
        if (this.limboCache.hasPlayerData(name)) {
            this.limboCache.restoreData(player);
            this.limboCache.removeFromCache(player);
        } else {
            this.saveLoggedinPlayer(player);
        }
        this.playerCache.removePlayer(name);
    }

    private void saveLoggedinPlayer(Player player) {
        if (this.settings.getProperty(RestrictionSettings.SAVE_QUIT_LOCATION).booleanValue()) {
            Location loc = this.spawnLoader.getPlayerLocationOrSpawn(player);
            PlayerAuth auth = PlayerAuth.builder().name(player.getName().toLowerCase()).realName(player.getName()).location(loc).build();
            this.dataSource.updateQuitLoc(auth);
        }
        if (this.settings.getProperty(RestrictionSettings.TELEPORT_UNAUTHED_TO_SPAWN).booleanValue() && !this.settings.getProperty(RestrictionSettings.NO_TELEPORT).booleanValue() && !this.playerDataStorage.hasData(player)) {
            this.playerDataStorage.saveData(player);
        }
    }
}

