/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.initialization;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.Metrics;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.settings.properties.PluginSettings;
import java.io.IOException;
import org.bukkit.plugin.Plugin;

public class MetricsManager {
    private MetricsManager() {
    }

    public static void sendMetrics(AuthMe plugin, Settings settings) {
        try {
            Metrics metrics = new Metrics((Plugin)plugin);
            Metrics.Graph languageGraph = metrics.createGraph("Messages Language");
            String messagesLanguage = settings.getProperty(PluginSettings.MESSAGES_LANGUAGE);
            languageGraph.addPlotter(new Metrics.Plotter(messagesLanguage){

                @Override
                public int getValue() {
                    return 1;
                }
            });
            Metrics.Graph databaseBackend = metrics.createGraph("Database Backend");
            String dataSource = settings.getProperty(DatabaseSettings.BACKEND).toString();
            databaseBackend.addPlotter(new Metrics.Plotter(dataSource){

                @Override
                public int getValue() {
                    return 1;
                }
            });
            metrics.start();
        }
        catch (IOException e) {
            ConsoleLogger.logException("Can't send Metrics data! The plugin will work anyway...", e);
        }
    }
}

