/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.initialization;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.datasource.CacheDataSource;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.datasource.FlatFile;
import fr.xephi.authme.datasource.MySQL;
import fr.xephi.authme.datasource.SQLite;
import fr.xephi.authme.libs.authme.configme.knownproperties.PropertyEntry;
import fr.xephi.authme.libs.authme.configme.resource.YamlFileResource;
import fr.xephi.authme.output.ConsoleFilter;
import fr.xephi.authme.output.Log4JFilter;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.output.Messages;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.SettingsMigrationService;
import fr.xephi.authme.settings.properties.AuthMeSettingsRetriever;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.FileUtils;
import fr.xephi.authme.util.MigrationService;
import fr.xephi.authme.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import java.util.logging.Logger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Filter;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class Initializer {
    private static final String FLATFILE_FILENAME = "auths.db";
    private static final int SQLITE_MAX_SIZE = 4000;
    private AuthMe authMe;
    private BukkitService bukkitService;

    public Initializer(AuthMe authMe, BukkitService bukkitService) {
        this.authMe = authMe;
        this.bukkitService = bukkitService;
    }

    public static Settings createSettings(AuthMe authMe) throws Exception {
        SettingsMigrationService migrationService = new SettingsMigrationService(authMe.getDataFolder());
        List<PropertyEntry> knownProperties = AuthMeSettingsRetriever.getAllPropertyFields();
        File configFile = new File(authMe.getDataFolder(), "config.yml");
        if (FileUtils.copyFileFromResource(configFile, "config.yml")) {
            YamlFileResource resource = new YamlFileResource(configFile);
            return new Settings(authMe.getDataFolder(), resource, migrationService, knownProperties);
        }
        throw new Exception("Could not copy config.yml from JAR to plugin folder");
    }

    public DataSource setupDatabase(Settings settings) throws ClassNotFoundException, SQLException, IOException {
        DataSource dataSource;
        DataSourceType dataSourceType = settings.getProperty(DatabaseSettings.BACKEND);
        switch (dataSourceType) {
            case FILE: {
                File source = new File(this.authMe.getDataFolder(), FLATFILE_FILENAME);
                dataSource = new FlatFile(source);
                break;
            }
            case MYSQL: {
                dataSource = new MySQL(settings);
                break;
            }
            case SQLITE: {
                dataSource = new SQLite(settings);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown data source type '" + (Object)((Object)dataSourceType) + "'");
            }
        }
        DataSource convertedSource = MigrationService.convertFlatfileToSqlite(settings, dataSource);
        DataSource dataSource2 = dataSource = convertedSource == null ? dataSource : convertedSource;
        if (settings.getProperty(DatabaseSettings.USE_CACHING).booleanValue()) {
            dataSource = new CacheDataSource(dataSource);
        }
        if (DataSourceType.SQLITE.equals((Object)dataSourceType)) {
            this.checkDataSourceSize(dataSource);
        }
        return dataSource;
    }

    private void checkDataSourceSize(final DataSource dataSource) {
        this.bukkitService.runTaskAsynchronously(new Runnable(){

            @Override
            public void run() {
                int accounts = dataSource.getAccountsRegistered();
                if (accounts >= 4000) {
                    ConsoleLogger.warning("YOU'RE USING THE SQLITE DATABASE WITH " + accounts + "+ ACCOUNTS; FOR BETTER PERFORMANCE, PLEASE UPGRADE TO MYSQL!!");
                }
            }
        });
    }

    public void setupConsoleFilter(Settings settings, Logger logger) {
        if (!settings.getProperty(SecuritySettings.REMOVE_PASSWORD_FROM_CONSOLE).booleanValue()) {
            return;
        }
        try {
            Class.forName("org.apache.logging.log4j.core.filter.AbstractFilter");
            Initializer.setLog4JFilter();
        }
        catch (ClassNotFoundException | NoClassDefFoundError e) {
            ConsoleLogger.info("You're using Minecraft 1.6.x or older, Log4J support will be disabled");
            ConsoleFilter filter = new ConsoleFilter();
            logger.setFilter(filter);
            Bukkit.getLogger().setFilter(filter);
            Logger.getLogger("Minecraft").setFilter(filter);
        }
    }

    private static void setLog4JFilter() {
        org.apache.logging.log4j.core.Logger logger = (org.apache.logging.log4j.core.Logger)LogManager.getRootLogger();
        logger.addFilter((Filter)new Log4JFilter());
    }

    public void scheduleRecallEmailTask(Settings settings, final DataSource dataSource, final Messages messages) {
        if (!settings.getProperty(EmailSettings.RECALL_PLAYERS).booleanValue()) {
            return;
        }
        this.bukkitService.runTaskTimerAsynchronously(new Runnable(){

            @Override
            public void run() {
                for (PlayerAuth auth : dataSource.getLoggedPlayers()) {
                    Player player;
                    String email = auth.getEmail();
                    if (!StringUtils.isEmpty(email) && !"your@email.com".equalsIgnoreCase(email) || (player = Initializer.this.bukkitService.getPlayerExact(auth.getRealName())) == null) continue;
                    messages.send((CommandSender)player, MessageKey.ADD_EMAIL_MESSAGE);
                }
            }
        }, 1L, 1200 * settings.getProperty(EmailSettings.DELAY_RECALL));
    }
}

