/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.hooks;

import com.earth2me.essentials.Essentials;
import com.onarandombox.MultiverseCore.MultiverseCore;
import com.onarandombox.MultiverseCore.api.MVWorldManager;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.libs.jalu.injector.annotations.NoFieldScan;
import fr.xephi.authme.libs.javax.inject.Inject;
import java.io.File;
import net.minelink.ctplus.CombatTagPlus;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

@NoFieldScan
public class PluginHooks {
    private final PluginManager pluginManager;
    private Essentials essentials;
    private MultiverseCore multiverse;
    private CombatTagPlus combatTagPlus;

    @Inject
    public PluginHooks(PluginManager pluginManager) {
        this.pluginManager = pluginManager;
        this.tryHookToCombatPlus();
        this.tryHookToEssentials();
        this.tryHookToMultiverse();
    }

    public void setEssentialsSocialSpyStatus(Player player, boolean socialSpyStatus) {
        if (this.essentials != null) {
            this.essentials.getUser(player).setSocialSpyEnabled(socialSpyStatus);
        }
    }

    public File getEssentialsDataFolder() {
        if (this.essentials != null) {
            return this.essentials.getDataFolder();
        }
        return null;
    }

    public Location getMultiverseSpawn(World world) {
        MVWorldManager manager;
        if (this.multiverse != null && (manager = this.multiverse.getMVWorldManager()).isMVWorld(world)) {
            return manager.getMVWorld(world).getSpawnLocation();
        }
        return null;
    }

    public boolean isNpc(Player player) {
        return player.hasMetadata("NPC") || this.isNpcInCombatTagPlus(player);
    }

    private boolean isNpcInCombatTagPlus(Player player) {
        return this.combatTagPlus != null && this.combatTagPlus.getNpcPlayerHelper().isNpc(player);
    }

    public boolean isEssentialsAvailable() {
        return this.essentials != null;
    }

    public boolean isMultiverseAvailable() {
        return this.multiverse != null;
    }

    public boolean isCombatTagPlusAvailable() {
        return this.combatTagPlus != null;
    }

    public void tryHookToEssentials() {
        try {
            this.essentials = PluginHooks.getPlugin(this.pluginManager, "Essentials", Essentials.class);
        }
        catch (Exception | NoClassDefFoundError ignored) {
            this.essentials = null;
        }
    }

    public void tryHookToCombatPlus() {
        try {
            this.combatTagPlus = PluginHooks.getPlugin(this.pluginManager, "CombatTagPlus", CombatTagPlus.class);
        }
        catch (Exception | NoClassDefFoundError ignored) {
            this.combatTagPlus = null;
        }
    }

    public void tryHookToMultiverse() {
        try {
            this.multiverse = PluginHooks.getPlugin(this.pluginManager, "Multiverse-Core", MultiverseCore.class);
        }
        catch (Exception | NoClassDefFoundError ignored) {
            this.multiverse = null;
        }
    }

    public void unhookEssentials() {
        this.essentials = null;
    }

    public void unhookCombatPlus() {
        this.combatTagPlus = null;
    }

    public void unhookMultiverse() {
        this.multiverse = null;
    }

    private static <T extends Plugin> T getPlugin(PluginManager pluginManager, String name, Class<T> clazz) throws Exception, NoClassDefFoundError {
        if (pluginManager.isPluginEnabled(name)) {
            Plugin plugin = (Plugin)clazz.cast(pluginManager.getPlugin(name));
            ConsoleLogger.info("Hooked successfully into " + name);
            return (T)plugin;
        }
        return null;
    }
}

