/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.datasource.Columns;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.util.StringUtils;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SQLite
implements DataSource {
    private final String database;
    private final String tableName;
    private final Columns col;
    private Connection con;

    public SQLite(Settings settings) throws ClassNotFoundException, SQLException {
        this.database = settings.getProperty(DatabaseSettings.MYSQL_DATABASE);
        this.tableName = settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        this.col = new Columns(settings);
        try {
            this.connect();
            this.setup();
        }
        catch (ClassNotFoundException | SQLException ex) {
            ConsoleLogger.logException("Error during SQLite initialization:", ex);
            throw ex;
        }
    }

    @VisibleForTesting
    SQLite(Settings settings, Connection connection) {
        this.database = settings.getProperty(DatabaseSettings.MYSQL_DATABASE);
        this.tableName = settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        this.col = new Columns(settings);
        this.con = connection;
    }

    private static void logSqlException(SQLException e) {
        ConsoleLogger.logException("Error while executing SQL statement:", e);
    }

    private void connect() throws ClassNotFoundException, SQLException {
        Class.forName("org.sqlite.JDBC");
        ConsoleLogger.info("SQLite driver loaded");
        this.con = DriverManager.getConnection("jdbc:sqlite:plugins/AuthMe/" + this.database + ".db");
    }

    @VisibleForTesting
    protected void setup() throws SQLException {
        try (Statement st = this.con.createStatement();){
            st.executeUpdate("CREATE TABLE IF NOT EXISTS " + this.tableName + " (" + this.col.ID + " INTEGER AUTO_INCREMENT, " + this.col.NAME + " VARCHAR(255) NOT NULL UNIQUE, CONSTRAINT table_const_prim PRIMARY KEY (" + this.col.ID + "));");
            DatabaseMetaData md = this.con.getMetaData();
            if (this.isColumnMissing(md, this.col.REAL_NAME)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.REAL_NAME + " VARCHAR(255) NOT NULL DEFAULT 'Player';");
            }
            if (this.isColumnMissing(md, this.col.PASSWORD)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.PASSWORD + " VARCHAR(255) NOT NULL DEFAULT '';");
            }
            if (!this.col.SALT.isEmpty() && this.isColumnMissing(md, this.col.SALT)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.SALT + " VARCHAR(255);");
            }
            if (this.isColumnMissing(md, this.col.IP)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.IP + " VARCHAR(40) NOT NULL DEFAULT '';");
            }
            if (this.isColumnMissing(md, this.col.LAST_LOGIN)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LAST_LOGIN + " TIMESTAMP;");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_X)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_X + " DOUBLE NOT NULL DEFAULT '0.0';");
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_Y + " DOUBLE NOT NULL DEFAULT '0.0';");
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_Z + " DOUBLE NOT NULL DEFAULT '0.0';");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_WORLD)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_WORLD + " VARCHAR(255) NOT NULL DEFAULT 'world';");
            }
            if (this.isColumnMissing(md, this.col.EMAIL)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.EMAIL + " VARCHAR(255) DEFAULT 'your@email.com';");
            }
            if (this.isColumnMissing(md, this.col.IS_LOGGED)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.IS_LOGGED + " INT DEFAULT '0';");
            }
        }
        ConsoleLogger.info("SQLite Setup finished");
    }

    private boolean isColumnMissing(DatabaseMetaData metaData, String columnName) throws SQLException {
        try (ResultSet rs = metaData.getColumns(null, null, this.tableName, columnName);){
            boolean bl = !rs.next();
            return bl;
        }
    }

    @Override
    public void reload() {
        this.close(this.con);
        try {
            this.connect();
            this.setup();
        }
        catch (ClassNotFoundException | SQLException ex) {
            ConsoleLogger.logException("Error during SQLite initialization:", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAuthAvailable(String user) {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = this.con.prepareStatement("SELECT 1 FROM " + this.tableName + " WHERE LOWER(" + this.col.NAME + ")=LOWER(?);");
            pst.setString(1, user);
            rs = pst.executeQuery();
            boolean bl = rs.next();
            this.close(rs);
            this.close(pst);
            return bl;
        }
        catch (SQLException ex) {
            ConsoleLogger.warning(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(rs);
            this.close(pst);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashedPassword getPassword(String user) {
        boolean useSalt = !this.col.SALT.isEmpty();
        String sql = "SELECT " + this.col.PASSWORD + (useSalt ? ", " + this.col.SALT : "") + " FROM " + this.tableName + " WHERE " + this.col.NAME + "=?";
        try (PreparedStatement pst = this.con.prepareStatement(sql);){
            pst.setString(1, user);
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) return null;
                HashedPassword hashedPassword = new HashedPassword(rs.getString(this.col.PASSWORD), useSalt ? rs.getString(this.col.SALT) : null);
                return hashedPassword;
            }
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PlayerAuth getAuth(String user) {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE LOWER(" + this.col.NAME + ")=LOWER(?);");
            pst.setString(1, user);
            rs = pst.executeQuery();
            if (rs.next()) {
                PlayerAuth playerAuth = this.buildAuthFromResultSet(rs);
                this.close(rs);
                this.close(pst);
                return playerAuth;
            }
            this.close(rs);
            this.close(pst);
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(rs);
            this.close(pst);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean saveAuth(PlayerAuth auth) {
        PreparedStatement pst = null;
        try {
            HashedPassword password = auth.getPassword();
            if (this.col.SALT.isEmpty()) {
                if (!StringUtils.isEmpty(auth.getPassword().getSalt())) {
                    ConsoleLogger.warning("Warning! Detected hashed password with separate salt but the salt column is not set in the config!");
                }
                pst = this.con.prepareStatement("INSERT INTO " + this.tableName + "(" + this.col.NAME + "," + this.col.PASSWORD + "," + this.col.IP + "," + this.col.LAST_LOGIN + "," + this.col.REAL_NAME + "," + this.col.EMAIL + ") VALUES (?,?,?,?,?,?);");
                pst.setString(1, auth.getNickname());
                pst.setString(2, password.getHash());
                pst.setString(3, auth.getIp());
                pst.setLong(4, auth.getLastLogin());
                pst.setString(5, auth.getRealName());
                pst.setString(6, auth.getEmail());
                pst.executeUpdate();
            } else {
                pst = this.con.prepareStatement("INSERT INTO " + this.tableName + "(" + this.col.NAME + "," + this.col.PASSWORD + "," + this.col.IP + "," + this.col.LAST_LOGIN + "," + this.col.REAL_NAME + "," + this.col.EMAIL + "," + this.col.SALT + ") VALUES (?,?,?,?,?,?,?);");
                pst.setString(1, auth.getNickname());
                pst.setString(2, password.getHash());
                pst.setString(3, auth.getIp());
                pst.setLong(4, auth.getLastLogin());
                pst.setString(5, auth.getRealName());
                pst.setString(6, auth.getEmail());
                pst.setString(7, password.getSalt());
                pst.executeUpdate();
            }
            this.close(pst);
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(pst);
        }
        return true;
    }

    @Override
    public boolean updatePassword(PlayerAuth auth) {
        return this.updatePassword(auth.getNickname(), auth.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePassword(String user, HashedPassword password) {
        user = user.toLowerCase();
        PreparedStatement pst = null;
        try {
            boolean useSalt = !this.col.SALT.isEmpty();
            String sql = "UPDATE " + this.tableName + " SET " + this.col.PASSWORD + " = ?" + (useSalt ? ", " + this.col.SALT + " = ?" : "") + " WHERE " + this.col.NAME + " = ?";
            pst = this.con.prepareStatement(sql);
            pst.setString(1, password.getHash());
            if (useSalt) {
                pst.setString(2, password.getSalt());
                pst.setString(3, user);
            } else {
                pst.setString(2, user);
            }
            pst.executeUpdate();
            boolean bl = true;
            this.close(pst);
            return bl;
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(pst);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateSession(PlayerAuth auth) {
        PreparedStatement pst = null;
        try {
            pst = this.con.prepareStatement("UPDATE " + this.tableName + " SET " + this.col.IP + "=?, " + this.col.LAST_LOGIN + "=?, " + this.col.REAL_NAME + "=? WHERE " + this.col.NAME + "=?;");
            pst.setString(1, auth.getIp());
            pst.setLong(2, auth.getLastLogin());
            pst.setString(3, auth.getRealName());
            pst.setString(4, auth.getNickname());
            pst.executeUpdate();
            boolean bl = true;
            this.close(pst);
            return bl;
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(pst);
        }
        return false;
    }

    @Override
    public Set<String> getRecordsToPurge(long until, boolean includeEntriesWithLastLoginZero) {
        HashSet<String> list = new HashSet<String>();
        String select = "SELECT " + this.col.NAME + " FROM " + this.tableName + " WHERE " + this.col.LAST_LOGIN + " < ?";
        if (!includeEntriesWithLastLoginZero) {
            select = select + " AND " + this.col.LAST_LOGIN + " <> 0";
        }
        try (PreparedStatement selectPst = this.con.prepareStatement(select);){
            selectPst.setLong(1, until);
            try (ResultSet rs = selectPst.executeQuery();){
                while (rs.next()) {
                    list.add(rs.getString(this.col.NAME));
                }
            }
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        return list;
    }

    @Override
    public void purgeRecords(Collection<String> toPurge) {
        String delete = "DELETE FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
        try (PreparedStatement deletePst = this.con.prepareStatement(delete);){
            for (String name : toPurge) {
                deletePst.setString(1, name.toLowerCase());
                deletePst.executeUpdate();
            }
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAuth(String user) {
        PreparedStatement pst = null;
        try {
            pst = this.con.prepareStatement("DELETE FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;");
            pst.setString(1, user.toLowerCase());
            pst.executeUpdate();
            boolean bl = true;
            this.close(pst);
            return bl;
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(pst);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateQuitLoc(PlayerAuth auth) {
        PreparedStatement pst = null;
        try {
            pst = this.con.prepareStatement("UPDATE " + this.tableName + " SET " + this.col.LASTLOC_X + "=?, " + this.col.LASTLOC_Y + "=?, " + this.col.LASTLOC_Z + "=?, " + this.col.LASTLOC_WORLD + "=? WHERE " + this.col.NAME + "=?;");
            pst.setDouble(1, auth.getQuitLocX());
            pst.setDouble(2, auth.getQuitLocY());
            pst.setDouble(3, auth.getQuitLocZ());
            pst.setString(4, auth.getWorld());
            pst.setString(5, auth.getNickname());
            pst.executeUpdate();
            boolean bl = true;
            this.close(pst);
            return bl;
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(pst);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateEmail(PlayerAuth auth) {
        String sql = "UPDATE " + this.tableName + " SET " + this.col.EMAIL + "=? WHERE " + this.col.NAME + "=?;";
        try (PreparedStatement pst = this.con.prepareStatement(sql);){
            pst.setString(1, auth.getEmail());
            pst.setString(2, auth.getNickname());
            pst.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
            return false;
        }
    }

    @Override
    public void close() {
        try {
            if (this.con != null && !this.con.isClosed()) {
                this.con.close();
            }
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
    }

    private void close(Statement st) {
        if (st != null) {
            try {
                st.close();
            }
            catch (SQLException ex) {
                SQLite.logSqlException(ex);
            }
        }
    }

    private void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (SQLException ex) {
                SQLite.logSqlException(ex);
            }
        }
    }

    private void close(ResultSet rs) {
        if (rs != null) {
            try {
                rs.close();
            }
            catch (SQLException ex) {
                SQLite.logSqlException(ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllAuthsByIp(String ip) {
        PreparedStatement pst = null;
        ResultSet rs = null;
        ArrayList<String> countIp = new ArrayList<String>();
        try {
            pst = this.con.prepareStatement("SELECT " + this.col.NAME + " FROM " + this.tableName + " WHERE " + this.col.IP + "=?;");
            pst.setString(1, ip);
            rs = pst.executeQuery();
            while (rs.next()) {
                countIp.add(rs.getString(this.col.NAME));
            }
            ArrayList<String> arrayList = countIp;
            this.close(rs);
            this.close(pst);
            return arrayList;
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(rs);
            this.close(pst);
        }
        return new ArrayList<String>();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int countAuthsByEmail(String email) {
        String sql = "SELECT COUNT(1) FROM " + this.tableName + " WHERE " + this.col.EMAIL + " = ? COLLATE NOCASE;";
        try (PreparedStatement pst = this.con.prepareStatement(sql);){
            pst.setString(1, email);
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        return 0;
    }

    @Override
    public DataSourceType getType() {
        return DataSourceType.SQLITE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isLogged(String user) {
        PreparedStatement pst = null;
        ResultSet rs = null;
        try {
            pst = this.con.prepareStatement("SELECT * FROM " + this.tableName + " WHERE LOWER(" + this.col.NAME + ")=?;");
            pst.setString(1, user);
            rs = pst.executeQuery();
            if (rs.next()) {
                boolean bl = rs.getInt(this.col.IS_LOGGED) == 1;
                this.close(rs);
                this.close(pst);
                return bl;
            }
            this.close(rs);
            this.close(pst);
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(rs);
            this.close(pst);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLogged(String user) {
        PreparedStatement pst = null;
        try {
            pst = this.con.prepareStatement("UPDATE " + this.tableName + " SET " + this.col.IS_LOGGED + "=? WHERE LOWER(" + this.col.NAME + ")=?;");
            pst.setInt(1, 1);
            pst.setString(2, user);
            pst.executeUpdate();
            this.close(pst);
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(pst);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setUnlogged(String user) {
        PreparedStatement pst = null;
        if (user != null) {
            try {
                pst = this.con.prepareStatement("UPDATE " + this.tableName + " SET " + this.col.IS_LOGGED + "=? WHERE LOWER(" + this.col.NAME + ")=?;");
                pst.setInt(1, 0);
                pst.setString(2, user);
                pst.executeUpdate();
                this.close(pst);
            }
            catch (SQLException ex) {
                SQLite.logSqlException(ex);
            }
            finally {
                this.close(pst);
            }
        }
    }

    @Override
    public void purgeLogged() {
        PreparedStatement pst = null;
        try {
            pst = this.con.prepareStatement("UPDATE " + this.tableName + " SET " + this.col.IS_LOGGED + "=? WHERE " + this.col.IS_LOGGED + "=?;");
            pst.setInt(1, 0);
            pst.setInt(2, 1);
            pst.executeUpdate();
            this.close(pst);
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        finally {
            this.close(pst);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int getAccountsRegistered() {
        String sql = "SELECT COUNT(*) FROM " + this.tableName + ";";
        try (PreparedStatement pst = this.con.prepareStatement(sql);
             ResultSet rs = pst.executeQuery();){
            if (!rs.next()) return 0;
            int n = rs.getInt(1);
            return n;
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updateRealName(String user, String realName) {
        String sql = "UPDATE " + this.tableName + " SET " + this.col.REAL_NAME + "=? WHERE " + this.col.NAME + "=?;";
        try (PreparedStatement pst = this.con.prepareStatement(sql);){
            pst.setString(1, realName);
            pst.setString(2, user);
            pst.executeUpdate();
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
            return false;
        }
    }

    @Override
    public List<PlayerAuth> getAllAuths() {
        ArrayList<PlayerAuth> auths = new ArrayList<PlayerAuth>();
        String sql = "SELECT * FROM " + this.tableName + ";";
        try (PreparedStatement pst = this.con.prepareStatement(sql);
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                PlayerAuth auth = this.buildAuthFromResultSet(rs);
                auths.add(auth);
            }
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        return auths;
    }

    @Override
    public List<PlayerAuth> getLoggedPlayers() {
        ArrayList<PlayerAuth> auths = new ArrayList<PlayerAuth>();
        String sql = "SELECT * FROM " + this.tableName + " WHERE " + this.col.IS_LOGGED + "=1;";
        try (PreparedStatement pst = this.con.prepareStatement(sql);
             ResultSet rs = pst.executeQuery();){
            while (rs.next()) {
                PlayerAuth auth = this.buildAuthFromResultSet(rs);
                auths.add(auth);
            }
        }
        catch (SQLException ex) {
            SQLite.logSqlException(ex);
        }
        return auths;
    }

    private PlayerAuth buildAuthFromResultSet(ResultSet row) throws SQLException {
        String salt = !this.col.SALT.isEmpty() ? row.getString(this.col.SALT) : null;
        PlayerAuth.Builder authBuilder = PlayerAuth.builder().name(row.getString(this.col.NAME)).email(row.getString(this.col.EMAIL)).realName(row.getString(this.col.REAL_NAME)).password(row.getString(this.col.PASSWORD), salt).lastLogin(row.getLong(this.col.LAST_LOGIN)).locX(row.getDouble(this.col.LASTLOC_X)).locY(row.getDouble(this.col.LASTLOC_Y)).locZ(row.getDouble(this.col.LASTLOC_Z)).locWorld(row.getString(this.col.LASTLOC_WORLD));
        String ip = row.getString(this.col.IP);
        if (!ip.isEmpty()) {
            authBuilder.ip(ip);
        }
        return authBuilder.build();
    }
}

