/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import com.google.common.annotations.VisibleForTesting;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.datasource.Columns;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.libs.zaxxer.hikari.HikariDataSource;
import fr.xephi.authme.libs.zaxxer.hikari.pool.HikariPool;
import fr.xephi.authme.security.HashAlgorithm;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.security.crypts.XFBCRYPT;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import fr.xephi.authme.settings.properties.HooksSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import fr.xephi.authme.util.RuntimeUtils;
import fr.xephi.authme.util.StringUtils;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class MySQL
implements DataSource {
    private String host;
    private String port;
    private String username;
    private String password;
    private String database;
    private String tableName;
    private List<String> columnOthers;
    private Columns col;
    private HashAlgorithm hashAlgorithm;
    private HikariDataSource ds;
    private String phpBbPrefix;
    private int phpBbGroup;
    private String wordpressPrefix;

    public MySQL(Settings settings) throws ClassNotFoundException, SQLException, HikariPool.PoolInitializationException {
        this.setParameters(settings);
        try {
            this.setConnectionArguments();
        }
        catch (RuntimeException e) {
            if (e instanceof IllegalArgumentException) {
                ConsoleLogger.warning("Invalid database arguments! Please check your configuration!");
                ConsoleLogger.warning("If this error persists, please report it to the developer!");
            }
            if (e instanceof HikariPool.PoolInitializationException) {
                ConsoleLogger.warning("Can't initialize database connection! Please check your configuration!");
                ConsoleLogger.warning("If this error persists, please report it to the developer!");
            }
            ConsoleLogger.warning("Can't use the Hikari Connection Pool! Please, report this error to the developer!");
            throw e;
        }
        try {
            this.checkTablesAndColumns();
        }
        catch (SQLException e) {
            this.close();
            ConsoleLogger.logException("Can't initialize the MySQL database:", e);
            ConsoleLogger.warning("Please check your database settings in the config.yml file!");
            throw e;
        }
    }

    @VisibleForTesting
    MySQL(Settings settings, HikariDataSource hikariDataSource) {
        this.ds = hikariDataSource;
        this.setParameters(settings);
    }

    private void setParameters(Settings settings) {
        this.host = settings.getProperty(DatabaseSettings.MYSQL_HOST);
        this.port = settings.getProperty(DatabaseSettings.MYSQL_PORT);
        this.username = settings.getProperty(DatabaseSettings.MYSQL_USERNAME);
        this.password = settings.getProperty(DatabaseSettings.MYSQL_PASSWORD);
        this.database = settings.getProperty(DatabaseSettings.MYSQL_DATABASE);
        this.tableName = settings.getProperty(DatabaseSettings.MYSQL_TABLE);
        this.columnOthers = settings.getProperty(HooksSettings.MYSQL_OTHER_USERNAME_COLS);
        this.col = new Columns(settings);
        this.hashAlgorithm = settings.getProperty(SecuritySettings.PASSWORD_HASH);
        this.phpBbPrefix = settings.getProperty(HooksSettings.PHPBB_TABLE_PREFIX);
        this.phpBbGroup = settings.getProperty(HooksSettings.PHPBB_ACTIVATED_GROUP_ID);
        this.wordpressPrefix = settings.getProperty(HooksSettings.WORDPRESS_TABLE_PREFIX);
    }

    private void setConnectionArguments() throws RuntimeException {
        this.ds = new HikariDataSource();
        this.ds.setPoolName("AuthMeMYSQLPool");
        this.ds.setMaximumPoolSize(RuntimeUtils.getCoreCount());
        this.ds.setJdbcUrl("jdbc:mysql://" + this.host + ":" + this.port + "/" + this.database);
        this.ds.setUsername(this.username);
        this.ds.setPassword(this.password);
        this.ds.addDataSourceProperty("characterEncoding", "utf8");
        this.ds.addDataSourceProperty("encoding", "UTF-8");
        this.ds.addDataSourceProperty("useUnicode", "true");
        this.ds.addDataSourceProperty("rewriteBatchedStatements", "true");
        this.ds.addDataSourceProperty("jdbcCompliantTruncation", "false");
        this.ds.addDataSourceProperty("cachePrepStmts", "true");
        this.ds.addDataSourceProperty("prepStmtCacheSize", "275");
        this.ds.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        ConsoleLogger.info("Connection arguments loaded, Hikari ConnectionPool ready!");
    }

    @Override
    public void reload() throws RuntimeException {
        if (this.ds != null) {
            this.ds.close();
        }
        this.setConnectionArguments();
        ConsoleLogger.info("Hikari ConnectionPool arguments reloaded!");
    }

    private Connection getConnection() throws SQLException {
        return this.ds.getConnection();
    }

    private void checkTablesAndColumns() throws SQLException {
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();){
            String sql = "CREATE TABLE IF NOT EXISTS " + this.tableName + " (" + this.col.ID + " MEDIUMINT(8) UNSIGNED AUTO_INCREMENT,PRIMARY KEY (" + this.col.ID + ")) CHARACTER SET = utf8;";
            st.executeUpdate(sql);
            DatabaseMetaData md = con.getMetaData();
            if (this.isColumnMissing(md, this.col.NAME)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.NAME + " VARCHAR(255) NOT NULL UNIQUE AFTER " + this.col.ID + ";");
            }
            if (this.isColumnMissing(md, this.col.REAL_NAME)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.REAL_NAME + " VARCHAR(255) NOT NULL AFTER " + this.col.NAME + ";");
            }
            if (this.isColumnMissing(md, this.col.PASSWORD)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.PASSWORD + " VARCHAR(255) CHARACTER SET ascii COLLATE ascii_bin NOT NULL;");
            }
            if (!this.col.SALT.isEmpty() && this.isColumnMissing(md, this.col.SALT)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.SALT + " VARCHAR(255);");
            }
            if (this.isColumnMissing(md, this.col.IP)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.IP + " VARCHAR(40) CHARACTER SET ascii COLLATE ascii_bin NOT NULL;");
            }
            if (this.isColumnMissing(md, this.col.LAST_LOGIN)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LAST_LOGIN + " BIGINT NOT NULL DEFAULT 0;");
            } else {
                this.migrateLastLoginColumn(con, md);
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_X)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_X + " DOUBLE NOT NULL DEFAULT '0.0' AFTER " + this.col.LAST_LOGIN + " , ADD " + this.col.LASTLOC_Y + " DOUBLE NOT NULL DEFAULT '0.0' AFTER " + this.col.LASTLOC_X + " , ADD " + this.col.LASTLOC_Z + " DOUBLE NOT NULL DEFAULT '0.0' AFTER " + this.col.LASTLOC_Y);
            } else {
                st.executeUpdate("ALTER TABLE " + this.tableName + " MODIFY " + this.col.LASTLOC_X + " DOUBLE NOT NULL DEFAULT '0.0', MODIFY " + this.col.LASTLOC_Y + " DOUBLE NOT NULL DEFAULT '0.0', MODIFY " + this.col.LASTLOC_Z + " DOUBLE NOT NULL DEFAULT '0.0';");
            }
            if (this.isColumnMissing(md, this.col.LASTLOC_WORLD)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.LASTLOC_WORLD + " VARCHAR(255) NOT NULL DEFAULT 'world' AFTER " + this.col.LASTLOC_Z);
            }
            if (this.isColumnMissing(md, this.col.EMAIL)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.EMAIL + " VARCHAR(255) DEFAULT 'your@email.com' AFTER " + this.col.LASTLOC_WORLD);
            }
            if (this.isColumnMissing(md, this.col.IS_LOGGED)) {
                st.executeUpdate("ALTER TABLE " + this.tableName + " ADD COLUMN " + this.col.IS_LOGGED + " SMALLINT NOT NULL DEFAULT '0' AFTER " + this.col.EMAIL);
            }
        }
        ConsoleLogger.info("MySQL setup finished");
    }

    private boolean isColumnMissing(DatabaseMetaData metaData, String columnName) throws SQLException {
        try (ResultSet rs = metaData.getColumns(null, null, this.tableName, columnName);){
            boolean bl = !rs.next();
            return bl;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isAuthAvailable(String user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public HashedPassword getPassword(String user) {
        boolean useSalt = !this.col.SALT.isEmpty();
        String sql = "SELECT " + this.col.PASSWORD + (useSalt ? ", " + this.col.SALT : "") + " FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);){
            pst.setString(1, user.toLowerCase());
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) return null;
                HashedPassword hashedPassword = new HashedPassword(rs.getString(this.col.PASSWORD), useSalt ? rs.getString(this.col.SALT) : null);
                return hashedPassword;
            }
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    @Override
    public PlayerAuth getAuth(String user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean saveAuth(PlayerAuth auth) {
        try (Connection con = this.getConnection();){
            boolean useSalt = !this.col.SALT.isEmpty() || !StringUtils.isEmpty(auth.getPassword().getSalt());
            String sql = "INSERT INTO " + this.tableName + "(" + this.col.NAME + "," + this.col.PASSWORD + "," + this.col.IP + "," + this.col.LAST_LOGIN + "," + this.col.REAL_NAME + "," + this.col.EMAIL + (useSalt ? "," + this.col.SALT : "") + ") VALUES (?,?,?,?,?,?" + (useSalt ? ",?" : "") + ");";
            PreparedStatement pst = con.prepareStatement(sql);
            pst.setString(1, auth.getNickname());
            pst.setString(2, auth.getPassword().getHash());
            pst.setString(3, auth.getIp());
            pst.setLong(4, auth.getLastLogin());
            pst.setString(5, auth.getRealName());
            pst.setString(6, auth.getEmail());
            if (useSalt) {
                pst.setString(7, auth.getPassword().getSalt());
            }
            pst.executeUpdate();
            pst.close();
            if (!this.columnOthers.isEmpty()) {
                for (String column : this.columnOthers) {
                    pst = con.prepareStatement("UPDATE " + this.tableName + " SET " + column + "=? WHERE " + this.col.NAME + "=?;");
                    pst.setString(1, auth.getRealName());
                    pst.setString(2, auth.getNickname());
                    pst.executeUpdate();
                    pst.close();
                }
            }
            if (this.hashAlgorithm == HashAlgorithm.PHPBB) {
                sql = "SELECT " + this.col.ID + " FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
                pst = con.prepareStatement(sql);
                pst.setString(1, auth.getNickname());
                ResultSet rs = pst.executeQuery();
                if (rs.next()) {
                    int id = rs.getInt(this.col.ID);
                    sql = "INSERT INTO " + this.phpBbPrefix + "user_group (group_id, user_id, group_leader, user_pending) VALUES (?,?,?,?);";
                    PreparedStatement pst2 = con.prepareStatement(sql);
                    pst2.setInt(1, this.phpBbGroup);
                    pst2.setInt(2, id);
                    pst2.setInt(3, 0);
                    pst2.setInt(4, 0);
                    pst2.executeUpdate();
                    pst2.close();
                    sql = "UPDATE " + this.tableName + " SET " + this.tableName + ".username_clean=? WHERE " + this.col.NAME + "=?;";
                    pst2 = con.prepareStatement(sql);
                    pst2.setString(1, auth.getNickname());
                    pst2.setString(2, auth.getNickname());
                    pst2.executeUpdate();
                    pst2.close();
                    sql = "UPDATE " + this.tableName + " SET " + this.tableName + ".group_id=? WHERE " + this.col.NAME + "=?;";
                    pst2 = con.prepareStatement(sql);
                    pst2.setInt(1, this.phpBbGroup);
                    pst2.setString(2, auth.getNickname());
                    pst2.executeUpdate();
                    pst2.close();
                    long time = System.currentTimeMillis() / 1000L;
                    sql = "UPDATE " + this.tableName + " SET " + this.tableName + ".user_regdate=? WHERE " + this.col.NAME + "=?;";
                    pst2 = con.prepareStatement(sql);
                    pst2.setLong(1, time);
                    pst2.setString(2, auth.getNickname());
                    pst2.executeUpdate();
                    pst2.close();
                    sql = "UPDATE " + this.tableName + " SET " + this.tableName + ".user_lastvisit=? WHERE " + this.col.NAME + "=?;";
                    pst2 = con.prepareStatement(sql);
                    pst2.setLong(1, time);
                    pst2.setString(2, auth.getNickname());
                    pst2.executeUpdate();
                    pst2.close();
                    sql = "UPDATE " + this.phpBbPrefix + "config SET config_value = config_value + 1 WHERE config_name = 'num_users';";
                    pst2 = con.prepareStatement(sql);
                    pst2.executeUpdate();
                    pst2.close();
                }
                rs.close();
                pst.close();
            } else if (this.hashAlgorithm == HashAlgorithm.WORDPRESS) {
                pst = con.prepareStatement("SELECT " + this.col.ID + " FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;");
                pst.setString(1, auth.getNickname());
                ResultSet rs = pst.executeQuery();
                if (rs.next()) {
                    int id = rs.getInt(this.col.ID);
                    sql = "INSERT INTO " + this.wordpressPrefix + "usermeta (user_id, meta_key, meta_value) VALUES (?,?,?)";
                    PreparedStatement pst2 = con.prepareStatement(sql);
                    pst2.setInt(1, id);
                    pst2.setString(2, "first_name");
                    pst2.setString(3, "");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, "last_name");
                    pst2.setString(3, "");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, "nickname");
                    pst2.setString(3, auth.getNickname());
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, "description");
                    pst2.setString(3, "");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, "rich_editing");
                    pst2.setString(3, "true");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, "comment_shortcuts");
                    pst2.setString(3, "false");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, "admin_color");
                    pst2.setString(3, "fresh");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, "use_ssl");
                    pst2.setString(3, "0");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, "show_admin_bar_front");
                    pst2.setString(3, "true");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, this.wordpressPrefix + "capabilities");
                    pst2.setString(3, "a:1:{s:10:\"subscriber\";b:1;}");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, this.wordpressPrefix + "user_level");
                    pst2.setString(3, "0");
                    pst2.addBatch();
                    pst2.setInt(1, id);
                    pst2.setString(2, "default_password_nag");
                    pst2.setString(3, "");
                    pst2.addBatch();
                    pst2.executeBatch();
                    pst2.clearBatch();
                    pst2.close();
                }
                rs.close();
                pst.close();
            } else if (this.hashAlgorithm == HashAlgorithm.XFBCRYPT) {
                pst = con.prepareStatement("SELECT " + this.col.ID + " FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;");
                pst.setString(1, auth.getNickname());
                ResultSet rs = pst.executeQuery();
                if (rs.next()) {
                    int id = rs.getInt(this.col.ID);
                    sql = "INSERT INTO xf_user_authenticate (user_id, scheme_class, data) VALUES (?,?,?)";
                    PreparedStatement pst2 = con.prepareStatement(sql);
                    pst2.setInt(1, id);
                    pst2.setString(2, "XenForo_Authentication_Core12");
                    String serializedHash = XFBCRYPT.serializeHash(auth.getPassword().getHash());
                    byte[] bytes = serializedHash.getBytes();
                    Blob blob = con.createBlob();
                    blob.setBytes(1L, bytes);
                    pst2.setBlob(3, blob);
                    pst2.executeUpdate();
                    pst2.close();
                }
                rs.close();
                pst.close();
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
            return false;
        }
    }

    @Override
    public boolean updatePassword(PlayerAuth auth) {
        return this.updatePassword(auth.getNickname(), auth.getPassword());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean updatePassword(String user, HashedPassword password) {
        user = user.toLowerCase();
        try (Connection con = this.getConnection();){
            PreparedStatement pst;
            String sql;
            boolean useSalt;
            boolean bl = useSalt = !this.col.SALT.isEmpty();
            if (useSalt) {
                sql = String.format("UPDATE %s SET %s = ?, %s = ? WHERE %s = ?;", this.tableName, this.col.PASSWORD, this.col.SALT, this.col.NAME);
                pst = con.prepareStatement(sql);
                pst.setString(1, password.getHash());
                pst.setString(2, password.getSalt());
                pst.setString(3, user);
            } else {
                sql = String.format("UPDATE %s SET %s = ? WHERE %s = ?;", this.tableName, this.col.PASSWORD, this.col.NAME);
                pst = con.prepareStatement(sql);
                pst.setString(1, password.getHash());
                pst.setString(2, user);
            }
            pst.executeUpdate();
            pst.close();
            if (this.hashAlgorithm == HashAlgorithm.XFBCRYPT) {
                sql = "SELECT " + this.col.ID + " FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
                pst = con.prepareStatement(sql);
                pst.setString(1, user);
                ResultSet rs = pst.executeQuery();
                if (rs.next()) {
                    int id = rs.getInt(this.col.ID);
                    sql = "UPDATE xf_user_authenticate SET data=? WHERE " + this.col.ID + "=?;";
                    PreparedStatement pst2 = con.prepareStatement(sql);
                    String serializedHash = XFBCRYPT.serializeHash(password.getHash());
                    byte[] bytes = serializedHash.getBytes();
                    Blob blob = con.createBlob();
                    blob.setBytes(1L, bytes);
                    pst2.setBlob(1, blob);
                    pst2.setInt(2, id);
                    pst2.executeUpdate();
                    pst2.close();
                    sql = "UPDATE xf_user_authenticate SET scheme_class=? WHERE " + this.col.ID + "=?;";
                    pst2 = con.prepareStatement(sql);
                    pst2.setString(1, "XenForo_Authentication_Core12");
                    pst2.setInt(2, id);
                    pst2.executeUpdate();
                    pst2.close();
                }
                rs.close();
                pst.close();
            }
            boolean bl2 = true;
            return bl2;
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
            return false;
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean updateSession(PlayerAuth auth) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public Set<String> getRecordsToPurge(long until, boolean includeEntriesWithLastLoginZero) {
        HashSet<String> list = new HashSet<String>();
        String select = "SELECT " + this.col.NAME + " FROM " + this.tableName + " WHERE " + this.col.LAST_LOGIN + " < ?";
        if (!includeEntriesWithLastLoginZero) {
            select = select + " AND " + this.col.LAST_LOGIN + " <> 0";
        }
        try (Connection con = this.getConnection();
             PreparedStatement selectPst = con.prepareStatement(select);){
            selectPst.setLong(1, until);
            try (ResultSet rs = selectPst.executeQuery();){
                while (rs.next()) {
                    list.add(rs.getString(this.col.NAME));
                }
            }
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean removeAuth(String user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean updateQuitLoc(PlayerAuth auth) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean updateEmail(PlayerAuth auth) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void close() {
        if (this.ds != null && !this.ds.isClosed()) {
            this.ds.close();
        }
    }

    @Override
    public List<String> getAllAuthsByIp(String ip) {
        ArrayList<String> result = new ArrayList<String>();
        String sql = "SELECT " + this.col.NAME + " FROM " + this.tableName + " WHERE " + this.col.IP + "=?;";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);){
            pst.setString(1, ip);
            try (ResultSet rs = pst.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(this.col.NAME));
                }
            }
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int countAuthsByEmail(String email) {
        String sql = "SELECT COUNT(1) FROM " + this.tableName + " WHERE UPPER(" + this.col.EMAIL + ") = UPPER(?)";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);){
            pst.setString(1, email);
            try (ResultSet rs = pst.executeQuery();){
                if (!rs.next()) return 0;
                int n = rs.getInt(1);
                return n;
            }
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
        return 0;
    }

    @Override
    public void purgeRecords(Collection<String> toPurge) {
        String sql = "DELETE FROM " + this.tableName + " WHERE " + this.col.NAME + "=?;";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);){
            for (String name : toPurge) {
                pst.setString(1, name.toLowerCase());
                pst.executeUpdate();
            }
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
    }

    @Override
    public DataSourceType getType() {
        return DataSourceType.MYSQL;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isLogged(String user) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void setLogged(String user) {
        String sql = "UPDATE " + this.tableName + " SET " + this.col.IS_LOGGED + "=? WHERE " + this.col.NAME + "=?;";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);){
            pst.setInt(1, 1);
            pst.setString(2, user.toLowerCase());
            pst.executeUpdate();
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
    }

    @Override
    public void setUnlogged(String user) {
        String sql = "UPDATE " + this.tableName + " SET " + this.col.IS_LOGGED + "=? WHERE " + this.col.NAME + "=?;";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);){
            pst.setInt(1, 0);
            pst.setString(2, user.toLowerCase());
            pst.executeUpdate();
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
    }

    @Override
    public void purgeLogged() {
        String sql = "UPDATE " + this.tableName + " SET " + this.col.IS_LOGGED + "=? WHERE " + this.col.IS_LOGGED + "=?;";
        try (Connection con = this.getConnection();
             PreparedStatement pst = con.prepareStatement(sql);){
            pst.setInt(1, 0);
            pst.setInt(2, 1);
            pst.executeUpdate();
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
    }

    @Override
    public int getAccountsRegistered() {
        int result = 0;
        String sql = "SELECT COUNT(*) FROM " + this.tableName;
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            if (rs.next()) {
                result = rs.getInt(1);
            }
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean updateRealName(String user, String realName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<PlayerAuth> getAllAuths() {
        ArrayList<PlayerAuth> auths = new ArrayList<PlayerAuth>();
        try (Connection con = this.getConnection();){
            Statement st = con.createStatement();
            ResultSet rs = st.executeQuery("SELECT * FROM " + this.tableName);
            while (rs.next()) {
                PlayerAuth pAuth = this.buildAuthFromResultSet(rs);
                if (this.hashAlgorithm == HashAlgorithm.XFBCRYPT) {
                    try (PreparedStatement pst = con.prepareStatement("SELECT data FROM xf_user_authenticate WHERE " + this.col.ID + "=?;");){
                        int id = rs.getInt(this.col.ID);
                        pst.setInt(1, id);
                        ResultSet rs2 = pst.executeQuery();
                        if (rs2.next()) {
                            Blob blob = rs2.getBlob("data");
                            byte[] bytes = blob.getBytes(1L, (int)blob.length());
                            pAuth.setPassword(new HashedPassword(XFBCRYPT.getHashFromBlob(bytes)));
                        }
                        rs2.close();
                    }
                }
                auths.add(pAuth);
            }
            rs.close();
            st.close();
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
        return auths;
    }

    @Override
    public List<PlayerAuth> getLoggedPlayers() {
        ArrayList<PlayerAuth> auths = new ArrayList<PlayerAuth>();
        String sql = "SELECT * FROM " + this.tableName + " WHERE " + this.col.IS_LOGGED + "=1;";
        try (Connection con = this.getConnection();
             Statement st = con.createStatement();
             ResultSet rs = st.executeQuery(sql);){
            while (rs.next()) {
                PlayerAuth pAuth = this.buildAuthFromResultSet(rs);
                if (this.hashAlgorithm == HashAlgorithm.XFBCRYPT) {
                    try (PreparedStatement pst = con.prepareStatement("SELECT data FROM xf_user_authenticate WHERE " + this.col.ID + "=?;");){
                        int id = rs.getInt(this.col.ID);
                        pst.setInt(1, id);
                        ResultSet rs2 = pst.executeQuery();
                        if (rs2.next()) {
                            Blob blob = rs2.getBlob("data");
                            byte[] bytes = blob.getBytes(1L, (int)blob.length());
                            pAuth.setPassword(new HashedPassword(XFBCRYPT.getHashFromBlob(bytes)));
                        }
                        rs2.close();
                    }
                }
                auths.add(pAuth);
            }
        }
        catch (SQLException ex) {
            MySQL.logSqlException(ex);
        }
        return auths;
    }

    private PlayerAuth buildAuthFromResultSet(ResultSet row) throws SQLException {
        String salt = this.col.SALT.isEmpty() ? null : row.getString(this.col.SALT);
        int group = this.col.GROUP.isEmpty() ? -1 : row.getInt(this.col.GROUP);
        return PlayerAuth.builder().name(row.getString(this.col.NAME)).realName(row.getString(this.col.REAL_NAME)).password(row.getString(this.col.PASSWORD), salt).lastLogin(row.getLong(this.col.LAST_LOGIN)).ip(row.getString(this.col.IP)).locWorld(row.getString(this.col.LASTLOC_WORLD)).locX(row.getDouble(this.col.LASTLOC_X)).locY(row.getDouble(this.col.LASTLOC_Y)).locZ(row.getDouble(this.col.LASTLOC_Z)).email(row.getString(this.col.EMAIL)).groupId(group).build();
    }

    private void migrateLastLoginColumn(Connection con, DatabaseMetaData metaData) throws SQLException {
        int columnType;
        try (ResultSet rs = metaData.getColumns(null, null, this.tableName, this.col.LAST_LOGIN);){
            if (!rs.next()) {
                ConsoleLogger.warning("Could not get LAST_LOGIN meta data. This should never happen!");
                return;
            }
            columnType = rs.getInt("DATA_TYPE");
        }
        if (columnType == 93) {
            this.migrateLastLoginColumnFromTimestamp(con);
        } else if (columnType == 4) {
            this.migrateLastLoginColumnFromInt(con);
        }
    }

    private void migrateLastLoginColumnFromTimestamp(Connection con) throws SQLException {
        ConsoleLogger.info("Migrating lastlogin column from timestamp to bigint");
        String lastLoginOld = this.col.LAST_LOGIN + "_old";
        String sql = String.format("ALTER TABLE %s CHANGE COLUMN %s %s BIGINT", this.tableName, this.col.LAST_LOGIN, lastLoginOld);
        PreparedStatement pst = con.prepareStatement(sql);
        pst.execute();
        sql = String.format("ALTER TABLE %s ADD COLUMN %s BIGINT NOT NULL DEFAULT 0 AFTER %s", this.tableName, this.col.LAST_LOGIN, this.col.IP);
        con.prepareStatement(sql).execute();
        sql = String.format("UPDATE %s SET %s = UNIX_TIMESTAMP(%s) * 1000", this.tableName, this.col.LAST_LOGIN, lastLoginOld);
        con.prepareStatement(sql).execute();
        sql = String.format("ALTER TABLE %s DROP COLUMN %s", this.tableName, lastLoginOld);
        con.prepareStatement(sql).execute();
        ConsoleLogger.info("Finished migration of lastlogin (timestamp to bigint)");
    }

    private void migrateLastLoginColumnFromInt(Connection con) throws SQLException {
        ConsoleLogger.info("Migrating lastlogin column from int to bigint");
        String sql = String.format("ALTER TABLE %s MODIFY %s BIGINT;", this.tableName, this.col.LAST_LOGIN);
        con.prepareStatement(sql).execute();
        int rangeStart = 1262304000;
        int rangeEnd = 1514678400;
        sql = String.format("UPDATE %s SET %s = %s * 1000 WHERE %s > %d AND %s < %d;", this.tableName, this.col.LAST_LOGIN, this.col.LAST_LOGIN, this.col.LAST_LOGIN, rangeStart, this.col.LAST_LOGIN, rangeEnd);
        int changedRows = con.prepareStatement(sql).executeUpdate();
        ConsoleLogger.warning("You may have entries with invalid timestamps. Please check your data before purging. " + changedRows + " rows were migrated from seconds to milliseconds.");
    }

    private static void logSqlException(SQLException e) {
        ConsoleLogger.logException("Error during SQL operation:", e);
    }

    private static void close(ResultSet rs) {
        try {
            if (rs != null && !rs.isClosed()) {
                rs.close();
            }
        }
        catch (SQLException e) {
            ConsoleLogger.logException("Could not close ResultSet", e);
        }
    }

    private static void close(PreparedStatement pst) {
        try {
            if (pst != null && !pst.isClosed()) {
                pst.close();
            }
        }
        catch (SQLException e) {
            ConsoleLogger.logException("Could not close PreparedStatement", e);
        }
    }
}

