/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.security.crypts.HashedPassword;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

@Deprecated
public class FlatFile
implements DataSource {
    private final File source;

    public FlatFile(File source) throws IOException {
        this.source = source;
        if (!source.exists() && !source.createNewFile()) {
            throw new IOException("Could not create file '" + source.getPath() + "'");
        }
    }

    @Override
    public void reload() {
        throw new UnsupportedOperationException("Flatfile no longer supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean isAuthAvailable(String user) {
        boolean bl;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (args.length <= 1 || !args[0].equalsIgnoreCase(user)) continue;
                bl = true;
            }
        }
        catch (IOException ex) {
            boolean bl2;
            try {
                ConsoleLogger.warning(ex.getMessage());
                bl2 = false;
            }
            catch (Throwable throwable) {
                FlatFile.silentClose(br);
                throw throwable;
            }
            FlatFile.silentClose(br);
            return bl2;
        }
        FlatFile.silentClose(br);
        return false;
        FlatFile.silentClose(br);
        return bl;
    }

    @Override
    public HashedPassword getPassword(String user) {
        PlayerAuth auth = this.getAuth(user);
        if (auth != null) {
            return auth.getPassword();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean saveAuth(PlayerAuth auth) {
        if (this.isAuthAvailable(auth.getNickname())) {
            return false;
        }
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new FileWriter(this.source, true));
            bw.write(auth.getNickname() + ":" + auth.getPassword().getHash() + ":" + auth.getIp() + ":" + auth.getLastLogin() + ":" + auth.getQuitLocX() + ":" + auth.getQuitLocY() + ":" + auth.getQuitLocZ() + ":" + auth.getWorld() + ":" + auth.getEmail() + "\n");
        }
        catch (IOException ex) {
            boolean bl;
            try {
                ConsoleLogger.warning(ex.getMessage());
                bl = false;
            }
            catch (Throwable throwable) {
                FlatFile.silentClose(bw);
                throw throwable;
            }
            FlatFile.silentClose(bw);
            return bl;
        }
        FlatFile.silentClose(bw);
        return true;
    }

    @Override
    public synchronized boolean updatePassword(PlayerAuth auth) {
        return this.updatePassword(auth.getNickname(), auth.getPassword());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updatePassword(String user, HashedPassword password) {
        if (!this.isAuthAvailable(user = user.toLowerCase())) {
            return false;
        }
        PlayerAuth newAuth = null;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equals(user)) continue;
                newAuth = FlatFile.buildAuthFromArray(args);
                if (newAuth == null) break;
                newAuth.setPassword(password);
            }
        }
        catch (IOException ex) {
            boolean bl;
            try {
                ConsoleLogger.warning(ex.getMessage());
                bl = false;
            }
            catch (Throwable throwable) {
                FlatFile.silentClose(br);
                throw throwable;
            }
            FlatFile.silentClose(br);
            return bl;
        }
        FlatFile.silentClose(br);
        if (newAuth != null) {
            this.removeAuth(user);
            this.saveAuth(newAuth);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateSession(PlayerAuth auth) {
        if (!this.isAuthAvailable(auth.getNickname())) {
            return false;
        }
        PlayerAuth newAuth = null;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase(auth.getNickname())) continue;
                newAuth = FlatFile.buildAuthFromArray(args);
                if (newAuth == null) break;
                newAuth.setLastLogin(auth.getLastLogin());
                newAuth.setIp(auth.getIp());
            }
        }
        catch (IOException ex) {
            boolean bl;
            try {
                ConsoleLogger.warning(ex.getMessage());
                bl = false;
            }
            catch (Throwable throwable) {
                FlatFile.silentClose(br);
                throw throwable;
            }
            FlatFile.silentClose(br);
            return bl;
        }
        FlatFile.silentClose(br);
        if (newAuth != null) {
            this.removeAuth(auth.getNickname());
            this.saveAuth(newAuth);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateQuitLoc(PlayerAuth auth) {
        if (!this.isAuthAvailable(auth.getNickname())) {
            return false;
        }
        PlayerAuth newAuth = null;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase(auth.getNickname())) continue;
                newAuth = FlatFile.buildAuthFromArray(args);
                if (newAuth == null) break;
                newAuth.setQuitLocX(auth.getQuitLocX());
                newAuth.setQuitLocY(auth.getQuitLocY());
                newAuth.setQuitLocZ(auth.getQuitLocZ());
                newAuth.setWorld(auth.getWorld());
                newAuth.setEmail(auth.getEmail());
            }
        }
        catch (IOException ex) {
            boolean bl;
            try {
                ConsoleLogger.warning(ex.getMessage());
                bl = false;
            }
            catch (Throwable throwable) {
                FlatFile.silentClose(br);
                throw throwable;
            }
            FlatFile.silentClose(br);
            return bl;
        }
        FlatFile.silentClose(br);
        if (newAuth != null) {
            this.removeAuth(auth.getNickname());
            this.saveAuth(newAuth);
        }
        return true;
    }

    @Override
    public Set<String> getRecordsToPurge(long until, boolean includeEntriesWithLastLoginZero) {
        throw new UnsupportedOperationException("Flat file no longer supported");
    }

    @Override
    public void purgeRecords(Collection<String> toPurge) {
        throw new UnsupportedOperationException("Flat file no longer supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized boolean removeAuth(String user) {
        if (!this.isAuthAvailable(user)) {
            return false;
        }
        BufferedReader br = null;
        BufferedWriter bw = null;
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (args.length <= 1 || args[0].equals(user)) continue;
                lines.add(line);
            }
            bw = new BufferedWriter(new FileWriter(this.source));
            for (String l : lines) {
                bw.write(l + "\n");
            }
        }
        catch (IOException ex) {
            boolean bl;
            try {
                ConsoleLogger.warning(ex.getMessage());
                bl = false;
            }
            catch (Throwable throwable) {
                FlatFile.silentClose(br);
                FlatFile.silentClose(bw);
                throw throwable;
            }
            FlatFile.silentClose(br);
            FlatFile.silentClose(bw);
            return bl;
        }
        FlatFile.silentClose(br);
        FlatFile.silentClose(bw);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized PlayerAuth getAuth(String user) {
        PlayerAuth playerAuth;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equalsIgnoreCase(user)) continue;
                playerAuth = FlatFile.buildAuthFromArray(args);
            }
        }
        catch (IOException ex) {
            PlayerAuth playerAuth2;
            try {
                ConsoleLogger.warning(ex.getMessage());
                playerAuth2 = null;
            }
            catch (Throwable throwable) {
                FlatFile.silentClose(br);
                throw throwable;
            }
            FlatFile.silentClose(br);
            return playerAuth2;
        }
        FlatFile.silentClose(br);
        return null;
        FlatFile.silentClose(br);
        return playerAuth;
    }

    @Override
    public synchronized void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateEmail(PlayerAuth auth) {
        if (!this.isAuthAvailable(auth.getNickname())) {
            return false;
        }
        PlayerAuth newAuth = null;
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (!args[0].equals(auth.getNickname())) continue;
                newAuth = FlatFile.buildAuthFromArray(args);
                if (newAuth != null) {
                    newAuth.setEmail(auth.getEmail());
                }
                break;
            }
        }
        catch (FileNotFoundException ex) {
            ConsoleLogger.warning(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            ConsoleLogger.warning(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (newAuth != null) {
            this.removeAuth(auth.getNickname());
            this.saveAuth(newAuth);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getAllAuthsByIp(String ip) {
        BufferedReader br = null;
        ArrayList<String> countIp = new ArrayList<String>();
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (args.length <= 3 || !args[2].equals(ip)) continue;
                countIp.add(args[0]);
            }
            ArrayList<String> arrayList = countIp;
            return arrayList;
        }
        catch (FileNotFoundException ex) {
            ConsoleLogger.warning(ex.getMessage());
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        catch (IOException ex) {
            ConsoleLogger.warning(ex.getMessage());
            ArrayList<String> arrayList = new ArrayList<String>();
            return arrayList;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int countAuthsByEmail(String email) {
        BufferedReader br = null;
        int countEmail = 0;
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                if (args.length <= 8 || !args[8].equals(email)) continue;
                ++countEmail;
            }
            int n = countEmail;
            return n;
        }
        catch (IOException ex) {
            ConsoleLogger.warning(ex.getMessage());
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return 0;
    }

    @Override
    public DataSourceType getType() {
        return DataSourceType.FILE;
    }

    @Override
    public boolean isLogged(String user) {
        return PlayerCache.getInstance().isAuthenticated(user);
    }

    @Override
    public void setLogged(String user) {
    }

    @Override
    public void setUnlogged(String user) {
    }

    @Override
    public void purgeLogged() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getAccountsRegistered() {
        BufferedReader br = null;
        int result = 0;
        try {
            br = new BufferedReader(new FileReader(this.source));
            while (br.readLine() != null) {
                ++result;
            }
        }
        catch (Exception ex) {
            int n;
            try {
                ConsoleLogger.warning(ex.getMessage());
                n = result;
            }
            catch (Throwable throwable) {
                FlatFile.silentClose(br);
                throw throwable;
            }
            FlatFile.silentClose(br);
            return n;
        }
        FlatFile.silentClose(br);
        return result;
    }

    @Override
    public boolean updateRealName(String user, String realName) {
        throw new UnsupportedOperationException("Flat file no longer supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<PlayerAuth> getAllAuths() {
        BufferedReader br = null;
        ArrayList<PlayerAuth> auths = new ArrayList<PlayerAuth>();
        try {
            String line;
            br = new BufferedReader(new FileReader(this.source));
            while ((line = br.readLine()) != null) {
                String[] args = line.split(":");
                PlayerAuth auth = FlatFile.buildAuthFromArray(args);
                if (auth == null) continue;
                auths.add(auth);
            }
            FlatFile.silentClose(br);
        }
        catch (IOException ex) {
            ConsoleLogger.logException("Error while getting auths from flatfile:", ex);
        }
        finally {
            FlatFile.silentClose(br);
        }
        return auths;
    }

    @Override
    public List<PlayerAuth> getLoggedPlayers() {
        throw new UnsupportedOperationException("Flat file no longer supported");
    }

    private static PlayerAuth buildAuthFromArray(String[] args) {
        if (args.length >= 2 && args.length <= 9 && args.length != 5 && args.length != 6) {
            PlayerAuth.Builder builder = PlayerAuth.builder().name(args[0]).realName(args[0]).password(args[1], null);
            if (args.length >= 3) {
                builder.ip(args[2]);
            }
            if (args.length >= 4) {
                builder.lastLogin(Long.parseLong(args[3]));
            }
            if (args.length >= 7) {
                builder.locX(Double.parseDouble(args[4])).locY(Double.parseDouble(args[5])).locZ(Double.parseDouble(args[6]));
            }
            if (args.length >= 8) {
                builder.locWorld(args[7]);
            }
            if (args.length >= 9) {
                builder.email(args[8]);
            }
            return builder.build();
        }
        return null;
    }

    private static void silentClose(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

