/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.datasource;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.security.crypts.HashedPassword;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class CacheDataSource
implements DataSource {
    private final DataSource source;
    private final LoadingCache<String, Optional<PlayerAuth>> cachedAuths;
    private final ListeningExecutorService executorService;

    public CacheDataSource(DataSource src) {
        this.source = src;
        this.executorService = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("AuthMe-CacheLoader").build()));
        this.cachedAuths = CacheBuilder.newBuilder().refreshAfterWrite(5L, TimeUnit.MINUTES).expireAfterAccess(15L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Optional<PlayerAuth>>(){

            public Optional<PlayerAuth> load(String key) {
                return Optional.fromNullable((Object)CacheDataSource.this.source.getAuth(key));
            }

            public ListenableFuture<Optional<PlayerAuth>> reload(final String key, Optional<PlayerAuth> oldValue) {
                return CacheDataSource.this.executorService.submit((Callable)new Callable<Optional<PlayerAuth>>(){

                    @Override
                    public Optional<PlayerAuth> call() {
                        return this.load(key);
                    }
                });
            }
        });
    }

    public LoadingCache<String, Optional<PlayerAuth>> getCachedAuths() {
        return this.cachedAuths;
    }

    @Override
    public void reload() {
        this.source.reload();
    }

    @Override
    public boolean isAuthAvailable(String user) {
        return this.getAuth(user) != null;
    }

    @Override
    public HashedPassword getPassword(String user) {
        Optional pAuthOpt = (Optional)this.cachedAuths.getIfPresent((Object)(user = user.toLowerCase()));
        if (pAuthOpt != null && pAuthOpt.isPresent()) {
            return ((PlayerAuth)pAuthOpt.get()).getPassword();
        }
        return this.source.getPassword(user);
    }

    @Override
    public PlayerAuth getAuth(String user) {
        user = user.toLowerCase();
        return (PlayerAuth)((Optional)this.cachedAuths.getUnchecked((Object)user)).orNull();
    }

    @Override
    public boolean saveAuth(PlayerAuth auth) {
        boolean result = this.source.saveAuth(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public boolean updatePassword(PlayerAuth auth) {
        boolean result = this.source.updatePassword(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public boolean updatePassword(String user, HashedPassword password) {
        boolean result = this.source.updatePassword(user = user.toLowerCase(), password);
        if (result) {
            this.cachedAuths.refresh((Object)user);
        }
        return result;
    }

    @Override
    public boolean updateSession(PlayerAuth auth) {
        boolean result = this.source.updateSession(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public boolean updateQuitLoc(PlayerAuth auth) {
        boolean result = this.source.updateQuitLoc(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public Set<String> getRecordsToPurge(long until, boolean includeEntriesWithLastLoginZero) {
        return this.source.getRecordsToPurge(until, includeEntriesWithLastLoginZero);
    }

    @Override
    public boolean removeAuth(String name) {
        boolean result = this.source.removeAuth(name = name.toLowerCase());
        if (result) {
            this.cachedAuths.invalidate((Object)name);
        }
        return result;
    }

    @Override
    public void close() {
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            ConsoleLogger.logException("Could not close executor service:", e);
        }
        this.cachedAuths.invalidateAll();
        this.source.close();
    }

    @Override
    public boolean updateEmail(PlayerAuth auth) {
        boolean result = this.source.updateEmail(auth);
        if (result) {
            this.cachedAuths.refresh((Object)auth.getNickname());
        }
        return result;
    }

    @Override
    public List<String> getAllAuthsByIp(String ip) {
        return this.source.getAllAuthsByIp(ip);
    }

    @Override
    public int countAuthsByEmail(String email) {
        return this.source.countAuthsByEmail(email);
    }

    @Override
    public void purgeRecords(Collection<String> banned) {
        this.source.purgeRecords(banned);
        this.cachedAuths.invalidateAll(banned);
    }

    @Override
    public DataSourceType getType() {
        return this.source.getType();
    }

    @Override
    public boolean isLogged(String user) {
        return PlayerCache.getInstance().isAuthenticated(user);
    }

    @Override
    public void setLogged(String user) {
        this.source.setLogged(user.toLowerCase());
    }

    @Override
    public void setUnlogged(String user) {
        this.source.setUnlogged(user.toLowerCase());
    }

    @Override
    public void purgeLogged() {
        this.source.purgeLogged();
        this.cachedAuths.invalidateAll();
    }

    @Override
    public int getAccountsRegistered() {
        return this.source.getAccountsRegistered();
    }

    @Override
    public boolean updateRealName(String user, String realName) {
        boolean result = this.source.updateRealName(user, realName);
        if (result) {
            this.cachedAuths.refresh((Object)user);
        }
        return result;
    }

    @Override
    public List<PlayerAuth> getAllAuths() {
        return this.source.getAllAuths();
    }

    @Override
    public List<PlayerAuth> getLoggedPlayers() {
        return new ArrayList<PlayerAuth>(PlayerCache.getInstance().getCache().values());
    }
}

