/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.converter;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.converter.Converter;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.util.StringUtils;
import java.io.File;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.YamlConfiguration;

public class RoyalAuthConverter
implements Converter {
    private static final String LAST_LOGIN_PATH = "timestamps.quit";
    private static final String PASSWORD_PATH = "login.password";
    private final AuthMe plugin;
    private final DataSource dataSource;

    @Inject
    RoyalAuthConverter(AuthMe plugin, DataSource dataSource) {
        this.plugin = plugin;
        this.dataSource = dataSource;
    }

    @Override
    public void execute(CommandSender sender) {
        for (OfflinePlayer player : this.plugin.getServer().getOfflinePlayers()) {
            try {
                String name = player.getName().toLowerCase();
                File file = new File(StringUtils.makePath(".", "plugins", "RoyalAuth", "userdata", name + ".yml"));
                if (this.dataSource.isAuthAvailable(name) || !file.exists()) continue;
                YamlConfiguration configuration = YamlConfiguration.loadConfiguration((File)file);
                PlayerAuth auth = PlayerAuth.builder().name(name).password(configuration.getString(PASSWORD_PATH), null).lastLogin(configuration.getLong(LAST_LOGIN_PATH)).realName(player.getName()).build();
                this.dataSource.saveAuth(auth);
            }
            catch (Exception e) {
                ConsoleLogger.logException("Error while trying to import " + player.getName() + " RoyalAuth data", e);
            }
        }
    }
}

