/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.converter;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.converter.Converter;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.ConverterSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.command.CommandSender;

public class RakamakConverter
implements Converter {
    private final DataSource database;
    private final Settings settings;
    private final File pluginFolder;
    private final PasswordSecurity passwordSecurity;

    @Inject
    RakamakConverter(@DataFolder File dataFolder, DataSource dataSource, Settings settings, PasswordSecurity passwordSecurity) {
        this.database = dataSource;
        this.settings = settings;
        this.pluginFolder = dataFolder;
        this.passwordSecurity = passwordSecurity;
    }

    @Override
    public void execute(CommandSender sender) {
        boolean useIP = this.settings.getProperty(ConverterSettings.RAKAMAK_USE_IP);
        String fileName = this.settings.getProperty(ConverterSettings.RAKAMAK_FILE_NAME);
        String ipFileName = this.settings.getProperty(ConverterSettings.RAKAMAK_IP_FILE_NAME);
        File source = new File(this.pluginFolder, fileName);
        File ipfiles = new File(this.pluginFolder, ipFileName);
        HashMap<String, String> playerIP = new HashMap<String, String>();
        HashMap<String, HashedPassword> playerPSW = new HashMap<String, HashedPassword>();
        try {
            String line;
            BufferedReader ipFile = new BufferedReader(new FileReader(ipfiles));
            if (useIP) {
                String tempLine;
                while ((tempLine = ipFile.readLine()) != null) {
                    if (!tempLine.contains("=")) continue;
                    String[] args = tempLine.split("=");
                    playerIP.put(args[0], args[1]);
                }
            }
            ipFile.close();
            BufferedReader users = new BufferedReader(new FileReader(source));
            while ((line = users.readLine()) != null) {
                if (!line.contains("=")) continue;
                String[] arguments = line.split("=");
                HashedPassword hashedPassword = this.passwordSecurity.computeHash(arguments[1], arguments[0]);
                playerPSW.put(arguments[0], hashedPassword);
            }
            users.close();
            for (Map.Entry m : playerPSW.entrySet()) {
                String playerName = (String)m.getKey();
                HashedPassword psw = (HashedPassword)playerPSW.get(playerName);
                String ip = useIP ? (String)playerIP.get(playerName) : "127.0.0.1";
                PlayerAuth auth = PlayerAuth.builder().name(playerName).realName(playerName).ip(ip).password(psw).lastLogin(0L).build();
                this.database.saveAuth(auth);
            }
            ConsoleLogger.info("Rakamak database has been imported correctly");
            sender.sendMessage("Rakamak database has been imported correctly");
        }
        catch (IOException ex) {
            ConsoleLogger.logException("Can't open the rakamak database file! Does it exist?", ex);
        }
    }
}

