/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.converter;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.converter.Converter;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.initialization.DataFolder;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.ConverterSettings;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import org.bukkit.command.CommandSender;

public class CrazyLoginConverter
implements Converter {
    private final DataSource database;
    private final Settings settings;
    private final File dataFolder;

    @Inject
    CrazyLoginConverter(@DataFolder File dataFolder, DataSource dataSource, Settings settings) {
        this.dataFolder = dataFolder;
        this.database = dataSource;
        this.settings = settings;
    }

    @Override
    public void execute(CommandSender sender) {
        String fileName = this.settings.getProperty(ConverterSettings.CRAZYLOGIN_FILE_NAME);
        File source = new File(this.dataFolder, fileName);
        if (!source.exists()) {
            sender.sendMessage("CrazyLogin file not found, please put " + fileName + " in AuthMe folder!");
            return;
        }
        try (BufferedReader users = new BufferedReader(new FileReader(source));){
            String line;
            while ((line = users.readLine()) != null) {
                String[] args;
                if (!line.contains("|") || (args = line.split("\\|")).length < 2 || "name".equalsIgnoreCase(args[0])) continue;
                String playerName = args[0];
                String password = args[1];
                if (password == null) continue;
                PlayerAuth auth = PlayerAuth.builder().name(playerName.toLowerCase()).realName(playerName).password(password, null).build();
                this.database.saveAuth(auth);
            }
            ConsoleLogger.info("CrazyLogin database has been imported correctly");
        }
        catch (IOException ex) {
            ConsoleLogger.warning("Can't open the crazylogin database file! Does it exist?");
            ConsoleLogger.logException("Encountered", ex);
        }
    }
}

