/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.converter;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.converter.Converter;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.datasource.DataSourceType;
import fr.xephi.authme.util.StringUtils;
import java.util.ArrayList;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;

public abstract class AbstractDataSourceConverter<S extends DataSource>
implements Converter {
    private DataSource destination;
    private DataSourceType destinationType;

    public AbstractDataSourceConverter(DataSource destination, DataSourceType destinationType) {
        this.destination = destination;
        this.destinationType = destinationType;
    }

    @Override
    public void execute(CommandSender sender) {
        S source;
        if (!this.destinationType.equals((Object)this.destination.getType())) {
            if (sender != null) {
                sender.sendMessage("Please configure your connection to " + (Object)((Object)this.destinationType) + " and re-run this command");
            }
            return;
        }
        try {
            source = this.getSource();
        }
        catch (Exception e) {
            AbstractDataSourceConverter.logAndSendMessage(sender, "The data source to convert from could not be initialized");
            ConsoleLogger.logException("Could not initialize source:", e);
            return;
        }
        ArrayList<String> skippedPlayers = new ArrayList<String>();
        for (PlayerAuth auth : source.getAllAuths()) {
            if (this.destination.isAuthAvailable(auth.getNickname())) {
                skippedPlayers.add(auth.getNickname());
                continue;
            }
            this.destination.saveAuth(auth);
            this.destination.updateQuitLoc(auth);
        }
        if (!skippedPlayers.isEmpty()) {
            AbstractDataSourceConverter.logAndSendMessage(sender, "Skipped conversion for players which were already in " + (Object)((Object)this.destinationType) + ": " + StringUtils.join(", ", skippedPlayers));
        }
        AbstractDataSourceConverter.logAndSendMessage(sender, "Database successfully converted from " + (Object)((Object)source.getType()) + " to " + (Object)((Object)this.destinationType));
    }

    protected abstract S getSource() throws Exception;

    private static void logAndSendMessage(CommandSender sender, String message) {
        ConsoleLogger.info(message);
        if (sender != null && !(sender instanceof ConsoleCommandSender)) {
            sender.sendMessage(message);
        }
    }
}

