/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.help;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import fr.xephi.authme.command.CommandArgumentDescription;
import fr.xephi.authme.command.CommandDescription;
import fr.xephi.authme.command.CommandUtils;
import fr.xephi.authme.command.FoundCommandResult;
import fr.xephi.authme.command.help.CommandSyntaxHelper;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.permission.DefaultPermission;
import fr.xephi.authme.permission.PermissionNode;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.PluginSettings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.ServerOperator;

public class HelpProvider
implements SettingsDependent {
    public static final int HIDE_COMMAND = 1;
    public static final int SHOW_LONG_DESCRIPTION = 2;
    public static final int SHOW_ARGUMENTS = 4;
    public static final int SHOW_PERMISSIONS = 8;
    public static final int SHOW_ALTERNATIVES = 16;
    public static final int SHOW_CHILDREN = 32;
    public static final int ALL_OPTIONS = -2;
    private final PermissionsManager permissionsManager;
    private String helpHeader;

    @Inject
    HelpProvider(PermissionsManager permissionsManager, Settings settings) {
        this.permissionsManager = permissionsManager;
        this.reload(settings);
    }

    private List<String> printHelp(CommandSender sender, FoundCommandResult result, int options) {
        if (result.getCommandDescription() == null) {
            return Collections.singletonList(ChatColor.DARK_RED + "Failed to retrieve any help information!");
        }
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(ChatColor.GOLD + "==========[ " + this.helpHeader + " HELP ]==========");
        CommandDescription command = result.getCommandDescription();
        ImmutableList labels = ImmutableList.copyOf(result.getLabels());
        ImmutableList correctLabels = ImmutableList.copyOf(HelpProvider.filterCorrectLabels(command, (List<String>)labels));
        if (!HelpProvider.hasFlag(1, options)) {
            lines.add(ChatColor.GOLD + "Command: " + CommandSyntaxHelper.getSyntax(command, (List<String>)correctLabels));
        }
        if (HelpProvider.hasFlag(2, options)) {
            HelpProvider.printDetailedDescription(command, lines);
        }
        if (HelpProvider.hasFlag(4, options)) {
            HelpProvider.printArguments(command, lines);
        }
        if (HelpProvider.hasFlag(8, options) && sender != null) {
            HelpProvider.printPermissions(command, sender, this.permissionsManager, lines);
        }
        if (HelpProvider.hasFlag(16, options)) {
            HelpProvider.printAlternatives(command, (List<String>)correctLabels, lines);
        }
        if (HelpProvider.hasFlag(32, options)) {
            HelpProvider.printChildren(command, (List<String>)labels, lines);
        }
        return lines;
    }

    public void outputHelp(CommandSender sender, FoundCommandResult result, int options) {
        List<String> lines = this.printHelp(sender, result, options);
        for (String line : lines) {
            sender.sendMessage(line);
        }
    }

    @Override
    public void reload(Settings settings) {
        this.helpHeader = settings.getProperty(PluginSettings.HELP_HEADER);
    }

    private static void printDetailedDescription(CommandDescription command, List<String> lines) {
        lines.add(ChatColor.GOLD + "Short description: " + ChatColor.WHITE + command.getDescription());
        lines.add(ChatColor.GOLD + "Detailed description:");
        lines.add(ChatColor.WHITE + " " + command.getDetailedDescription());
    }

    private static void printArguments(CommandDescription command, List<String> lines) {
        if (command.getArguments().isEmpty()) {
            return;
        }
        lines.add(ChatColor.GOLD + "Arguments:");
        StringBuilder argString = new StringBuilder();
        for (CommandArgumentDescription argument : command.getArguments()) {
            argString.setLength(0);
            argString.append(" ").append(ChatColor.YELLOW).append(ChatColor.ITALIC).append(argument.getName()).append(": ").append(ChatColor.WHITE).append(argument.getDescription());
            if (argument.isOptional()) {
                argString.append(ChatColor.GRAY).append(ChatColor.ITALIC).append(" (Optional)");
            }
            lines.add(argString.toString());
        }
    }

    private static void printAlternatives(CommandDescription command, List<String> correctLabels, List<String> lines) {
        if (command.getLabels().size() <= 1 || correctLabels.size() <= 1) {
            return;
        }
        lines.add(ChatColor.GOLD + "Alternatives:");
        String parentLabel = correctLabels.get(0);
        String childLabel = correctLabels.get(1);
        for (String entry : command.getLabels()) {
            if (entry.equalsIgnoreCase(childLabel)) continue;
            lines.add(" " + CommandSyntaxHelper.getSyntax(command, Arrays.asList(parentLabel, entry)));
        }
    }

    private static void printPermissions(CommandDescription command, CommandSender sender, PermissionsManager permissionsManager, List<String> lines) {
        PermissionNode permission = command.getPermission();
        if (permission == null) {
            return;
        }
        lines.add(ChatColor.GOLD + "Permissions:");
        boolean hasPermission = permissionsManager.hasPermission(sender, permission);
        String nodePermsString = "" + ChatColor.GRAY + ChatColor.ITALIC + (hasPermission ? " (You have permission)" : " (No permission)");
        lines.add(" " + ChatColor.YELLOW + ChatColor.ITALIC + permission.getNode() + nodePermsString);
        DefaultPermission defaultPermission = permission.getDefaultPermission();
        String addendum = "";
        if (DefaultPermission.OP_ONLY.equals((Object)defaultPermission)) {
            addendum = defaultPermission.evaluate((ServerOperator)sender) ? " (You have permission)" : " (No permission)";
        }
        lines.add(ChatColor.GOLD + "Default: " + ChatColor.GRAY + ChatColor.ITALIC + defaultPermission.getTitle() + addendum);
        if (permissionsManager.hasPermission(sender, command.getPermission())) {
            lines.add(ChatColor.GOLD + " Result: " + ChatColor.GREEN + ChatColor.ITALIC + "You have permission");
        } else {
            lines.add(ChatColor.GOLD + " Result: " + ChatColor.DARK_RED + ChatColor.ITALIC + "No permission");
        }
    }

    private static void printChildren(CommandDescription command, List<String> parentLabels, List<String> lines) {
        if (command.getChildren().isEmpty()) {
            return;
        }
        lines.add(ChatColor.GOLD + "Commands:");
        String parentCommandPath = CommandUtils.labelsToString(parentLabels);
        for (CommandDescription child : command.getChildren()) {
            lines.add(" /" + parentCommandPath + " " + child.getLabels().get(0) + ChatColor.GRAY + ChatColor.ITALIC + ": " + child.getDescription());
        }
    }

    private static boolean hasFlag(int flag, int options) {
        return (flag & options) != 0;
    }

    @VisibleForTesting
    protected static List<String> filterCorrectLabels(CommandDescription command, List<String> labels) {
        List<CommandDescription> commands = CommandUtils.constructParentList(command);
        ArrayList<String> correctLabels = new ArrayList<String>();
        boolean foundIncorrectLabel = false;
        for (int i = 0; i < commands.size(); ++i) {
            if (!foundIncorrectLabel && i < labels.size() && commands.get(i).hasLabel(labels.get(i))) {
                correctLabels.add(labels.get(i));
                continue;
            }
            foundIncorrectLabel = true;
            correctLabels.add(commands.get(i).getLabels().get(0));
        }
        return correctLabels;
    }
}

