/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.help;

import fr.xephi.authme.command.CommandArgumentDescription;
import fr.xephi.authme.command.CommandDescription;
import java.util.List;
import org.bukkit.ChatColor;

class CommandSyntaxHelper {
    private CommandSyntaxHelper() {
    }

    public static String getSyntax(CommandDescription command, List<String> correctLabels) {
        String commandSyntax = ChatColor.WHITE + "/" + correctLabels.get(0) + ChatColor.YELLOW;
        for (int i = 1; i < correctLabels.size(); ++i) {
            commandSyntax = commandSyntax + " " + correctLabels.get(i);
        }
        for (CommandArgumentDescription argument : command.getArguments()) {
            commandSyntax = commandSyntax + " " + CommandSyntaxHelper.formatArgument(argument);
        }
        return commandSyntax;
    }

    private static String formatArgument(CommandArgumentDescription argument) {
        if (argument.isOptional()) {
            return "[" + argument.getName() + "]";
        }
        return "<" + argument.getName() + ">";
    }
}

