/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.register;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.PlayerCommand;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.mail.SendMailSSL;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.security.HashAlgorithm;
import fr.xephi.authme.security.RandomString;
import fr.xephi.authme.settings.properties.EmailSettings;
import fr.xephi.authme.settings.properties.RegistrationSettings;
import fr.xephi.authme.settings.properties.RestrictionSettings;
import fr.xephi.authme.settings.properties.SecuritySettings;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RegisterCommand
extends PlayerCommand {
    @Inject
    private Management management;
    @Inject
    private CommandService commandService;
    @Inject
    private SendMailSSL sendMailSsl;

    @Override
    public void runCommand(Player player, List<String> arguments) {
        if (this.commandService.getProperty(SecuritySettings.PASSWORD_HASH) == HashAlgorithm.TWO_FACTOR) {
            this.management.performRegister(player, "", "", true);
            return;
        }
        boolean useConfirmation = this.isConfirmationRequired();
        if (arguments.isEmpty() || useConfirmation && arguments.size() < 2) {
            this.commandService.send((CommandSender)player, MessageKey.USAGE_REGISTER);
            return;
        }
        if (this.commandService.getProperty(RegistrationSettings.USE_EMAIL_REGISTRATION).booleanValue()) {
            this.handleEmailRegistration(player, arguments);
        } else {
            this.handlePasswordRegistration(player, arguments);
        }
    }

    @Override
    protected String getAlternativeCommand() {
        return "/authme register <playername> <password>";
    }

    private void handlePasswordRegistration(Player player, List<String> arguments) {
        if (this.commandService.getProperty(RestrictionSettings.ENABLE_PASSWORD_CONFIRMATION).booleanValue() && !arguments.get(0).equals(arguments.get(1))) {
            this.commandService.send((CommandSender)player, MessageKey.PASSWORD_MATCH_ERROR);
        } else {
            this.management.performRegister(player, arguments.get(0), "", true);
        }
    }

    private void handleEmailRegistration(Player player, List<String> arguments) {
        if (!this.sendMailSsl.hasAllInformation()) {
            this.commandService.send((CommandSender)player, MessageKey.INCOMPLETE_EMAIL_SETTINGS);
            ConsoleLogger.warning("Cannot register player '" + player.getName() + "': no email or password is set to send emails from. Please adjust your config at " + EmailSettings.MAIL_ACCOUNT.getPath());
            return;
        }
        String email = arguments.get(0);
        if (!this.commandService.validateEmail(email)) {
            this.commandService.send((CommandSender)player, MessageKey.INVALID_EMAIL);
        } else if (this.commandService.getProperty(RegistrationSettings.ENABLE_CONFIRM_EMAIL).booleanValue() && !email.equals(arguments.get(1))) {
            this.commandService.send((CommandSender)player, MessageKey.USAGE_REGISTER);
        } else {
            String thePass = RandomString.generate(this.commandService.getProperty(EmailSettings.RECOVERY_PASSWORD_LENGTH));
            this.management.performRegister(player, thePass, email, true);
        }
    }

    private boolean isConfirmationRequired() {
        return this.commandService.getProperty(RegistrationSettings.USE_EMAIL_REGISTRATION) != false ? this.commandService.getProperty(RegistrationSettings.ENABLE_CONFIRM_EMAIL).booleanValue() : this.commandService.getProperty(RestrictionSettings.ENABLE_PASSWORD_CONFIRMATION).booleanValue();
    }
}

