/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.email;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.PlayerCommand;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.mail.SendMailSSL;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.RandomString;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.service.RecoveryCodeManager;
import fr.xephi.authme.settings.properties.EmailSettings;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RecoverEmailCommand
extends PlayerCommand {
    @Inject
    private PasswordSecurity passwordSecurity;
    @Inject
    private CommandService commandService;
    @Inject
    private DataSource dataSource;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private SendMailSSL sendMailSsl;
    @Inject
    private RecoveryCodeManager recoveryCodeManager;

    @Override
    public void runCommand(Player player, List<String> arguments) {
        String playerMail = arguments.get(0);
        String playerName = player.getName();
        if (!this.sendMailSsl.hasAllInformation()) {
            ConsoleLogger.warning("Mail API is not set");
            this.commandService.send((CommandSender)player, MessageKey.INCOMPLETE_EMAIL_SETTINGS);
            return;
        }
        if (this.playerCache.isAuthenticated(playerName)) {
            this.commandService.send((CommandSender)player, MessageKey.ALREADY_LOGGED_IN_ERROR);
            return;
        }
        PlayerAuth auth = this.dataSource.getAuth(playerName);
        if (auth == null) {
            this.commandService.send((CommandSender)player, MessageKey.REGISTER_EMAIL_MESSAGE);
            return;
        }
        String email = auth.getEmail();
        if (email == null || !email.equalsIgnoreCase(playerMail) || "your@email.com".equalsIgnoreCase(email)) {
            this.commandService.send((CommandSender)player, MessageKey.INVALID_EMAIL);
            return;
        }
        if (this.recoveryCodeManager.isRecoveryCodeNeeded()) {
            if (arguments.size() == 1) {
                this.createAndSendRecoveryCode(player, email);
            } else {
                this.processRecoveryCode(player, arguments.get(1), email);
            }
        } else {
            this.generateAndSendNewPassword(player, email);
        }
    }

    private void createAndSendRecoveryCode(Player player, String email) {
        String recoveryCode = this.recoveryCodeManager.generateCode(player.getName());
        this.sendMailSsl.sendRecoveryCode(player.getName(), email, recoveryCode);
        this.commandService.send((CommandSender)player, MessageKey.RECOVERY_CODE_SENT);
    }

    private void processRecoveryCode(Player player, String code, String email) {
        String name = player.getName();
        if (!this.recoveryCodeManager.isCodeValid(name, code)) {
            this.commandService.send((CommandSender)player, MessageKey.INCORRECT_RECOVERY_CODE);
            return;
        }
        this.generateAndSendNewPassword(player, email);
        this.recoveryCodeManager.removeCode(name);
    }

    private void generateAndSendNewPassword(Player player, String email) {
        String name = player.getName();
        String thePass = RandomString.generate(this.commandService.getProperty(EmailSettings.RECOVERY_PASSWORD_LENGTH));
        HashedPassword hashNew = this.passwordSecurity.computeHash(thePass, name);
        this.dataSource.updatePassword(name, hashNew);
        this.sendMailSsl.sendPasswordMail(name, email, thePass);
        this.commandService.send((CommandSender)player, MessageKey.RECOVERY_EMAIL_SENT_MESSAGE);
    }
}

