/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.changepassword;

import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.PlayerCommand;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.util.ValidationService;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ChangePasswordCommand
extends PlayerCommand {
    @Inject
    private CommandService commandService;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private ValidationService validationService;
    @Inject
    private Management management;

    @Override
    public void runCommand(Player player, List<String> arguments) {
        String oldPassword = arguments.get(0);
        String newPassword = arguments.get(1);
        String name = player.getName().toLowerCase();
        if (!this.playerCache.isAuthenticated(name)) {
            this.commandService.send((CommandSender)player, MessageKey.NOT_LOGGED_IN);
            return;
        }
        ValidationService.ValidationResult passwordValidation = this.validationService.validatePassword(newPassword, name);
        if (passwordValidation.hasError()) {
            this.commandService.send((CommandSender)player, passwordValidation.getMessageKey(), passwordValidation.getArgs());
            return;
        }
        this.management.performPasswordChange(player, oldPassword, newPassword);
    }
}

