/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.captcha;

import fr.xephi.authme.cache.CaptchaManager;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.PlayerCommand;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CaptchaCommand
extends PlayerCommand {
    @Inject
    private PlayerCache playerCache;
    @Inject
    private CaptchaManager captchaManager;
    @Inject
    private CommandService commandService;

    @Override
    public void runCommand(Player player, List<String> arguments) {
        String playerName = player.getName().toLowerCase();
        if (this.playerCache.isAuthenticated(playerName)) {
            this.commandService.send((CommandSender)player, MessageKey.ALREADY_LOGGED_IN_ERROR);
        } else if (!this.captchaManager.isCaptchaRequired(playerName)) {
            this.commandService.send((CommandSender)player, MessageKey.USAGE_LOGIN);
        } else {
            this.checkCaptcha(player, arguments.get(0));
        }
    }

    private void checkCaptcha(Player player, String captchaCode) {
        boolean isCorrectCode = this.captchaManager.checkCode(player.getName(), captchaCode);
        if (isCorrectCode) {
            this.commandService.send((CommandSender)player, MessageKey.CAPTCHA_SUCCESS);
            this.commandService.send((CommandSender)player, MessageKey.LOGIN_MESSAGE);
        } else {
            String newCode = this.captchaManager.generateCode(player.getName());
            this.commandService.send((CommandSender)player, MessageKey.CAPTCHA_WRONG_ERROR, newCode);
        }
    }
}

