/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.settings.properties.PluginSettings;
import fr.xephi.authme.util.BukkitService;
import java.util.Collection;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class VersionCommand
implements ExecutableCommand {
    @Inject
    private BukkitService bukkitService;
    @Inject
    private CommandService commandService;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        sender.sendMessage(ChatColor.GOLD + "==========[ " + this.commandService.getProperty(PluginSettings.HELP_HEADER) + " ABOUT ]==========");
        sender.sendMessage(ChatColor.GOLD + "Version: " + ChatColor.WHITE + AuthMe.getPluginName() + " v" + AuthMe.getPluginVersion() + ChatColor.GRAY + " (build: " + AuthMe.getPluginBuildNumber() + ")");
        sender.sendMessage(ChatColor.GOLD + "Developers:");
        Collection<? extends Player> onlinePlayers = this.bukkitService.getOnlinePlayers();
        VersionCommand.printDeveloper(sender, "Alexandre Vanhecke", "xephi59", "Original Author", onlinePlayers);
        VersionCommand.printDeveloper(sender, "Lucas J.", "ljacqu", "Main Developer", onlinePlayers);
        VersionCommand.printDeveloper(sender, "Gnat008", "gnat008", "Developer", onlinePlayers);
        VersionCommand.printDeveloper(sender, "DNx5", "DNx5", "Developer", onlinePlayers);
        VersionCommand.printDeveloper(sender, "games647", "games647", "Developer", onlinePlayers);
        VersionCommand.printDeveloper(sender, "Tim Visee", "timvisee", "Developer", onlinePlayers);
        VersionCommand.printDeveloper(sender, "Gabriele C.", "sgdc3", "Project manager, Contributor", onlinePlayers);
        sender.sendMessage(ChatColor.GOLD + "Website: " + ChatColor.WHITE + "http://dev.bukkit.org/bukkit-plugins/authme-reloaded/");
        sender.sendMessage(ChatColor.GOLD + "License: " + ChatColor.WHITE + "GNU GPL v3.0" + ChatColor.GRAY + ChatColor.ITALIC + " (See LICENSE file)");
        sender.sendMessage(ChatColor.GOLD + "Copyright: " + ChatColor.WHITE + "Copyright (c) Xephi 2015. All rights reserved.");
    }

    private static void printDeveloper(CommandSender sender, String name, String minecraftName, String function, Collection<? extends Player> onlinePlayers) {
        StringBuilder msg = new StringBuilder();
        msg.append(" ").append(ChatColor.WHITE).append(name);
        msg.append(ChatColor.GRAY).append(" // ").append(ChatColor.WHITE).append(minecraftName);
        msg.append(ChatColor.GRAY).append(ChatColor.ITALIC).append(" (").append(function).append(")");
        if (VersionCommand.isPlayerOnline(minecraftName, onlinePlayers)) {
            msg.append(ChatColor.GREEN).append(ChatColor.ITALIC).append(" (In-Game)");
        }
        sender.sendMessage(msg.toString());
    }

    private static boolean isPlayerOnline(String minecraftName, Collection<? extends Player> onlinePlayers) {
        for (Player player : onlinePlayers) {
            if (!player.getName().equalsIgnoreCase(minecraftName)) continue;
            return true;
        }
        return false;
    }
}

