/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.process.Management;
import fr.xephi.authme.util.BukkitService;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class UnregisterAdminCommand
implements ExecutableCommand {
    @Inject
    private DataSource dataSource;
    @Inject
    private CommandService commandService;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private Management management;

    UnregisterAdminCommand() {
    }

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        String playerName = arguments.get(0);
        if (!this.dataSource.isAuthAvailable(playerName)) {
            this.commandService.send(sender, MessageKey.UNKNOWN_USER);
            return;
        }
        Player target = this.bukkitService.getPlayerExact(playerName);
        this.management.performUnregisterByAdmin(sender, playerName, target);
    }
}

