/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.util.BukkitService;
import java.util.List;
import org.bukkit.command.CommandSender;

public class SetEmailCommand
implements ExecutableCommand {
    @Inject
    private DataSource dataSource;
    @Inject
    private CommandService commandService;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private BukkitService bukkitService;

    @Override
    public void executeCommand(final CommandSender sender, List<String> arguments) {
        final String playerName = arguments.get(0);
        final String playerEmail = arguments.get(1);
        if (!this.commandService.validateEmail(playerEmail)) {
            this.commandService.send(sender, MessageKey.INVALID_EMAIL);
            return;
        }
        this.bukkitService.runTaskOptionallyAsync(new Runnable(){

            @Override
            public void run() {
                PlayerAuth auth = SetEmailCommand.this.dataSource.getAuth(playerName);
                if (auth == null) {
                    SetEmailCommand.this.commandService.send(sender, MessageKey.UNKNOWN_USER);
                    return;
                }
                if (!SetEmailCommand.this.commandService.isEmailFreeForRegistration(playerEmail, sender)) {
                    SetEmailCommand.this.commandService.send(sender, MessageKey.EMAIL_ALREADY_USED_ERROR);
                    return;
                }
                auth.setEmail(playerEmail);
                if (!SetEmailCommand.this.dataSource.updateEmail(auth)) {
                    SetEmailCommand.this.commandService.send(sender, MessageKey.ERROR);
                    return;
                }
                if (SetEmailCommand.this.playerCache.getAuth(playerName) != null) {
                    SetEmailCommand.this.playerCache.updatePlayer(auth);
                }
                SetEmailCommand.this.commandService.send(sender, MessageKey.EMAIL_CHANGED_SUCCESS);
            }
        });
    }
}

