/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.initialization.Reloadable;
import fr.xephi.authme.initialization.SettingsDependent;
import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.settings.properties.DatabaseSettings;
import java.util.Collection;
import java.util.List;
import org.bukkit.command.CommandSender;

public class ReloadCommand
implements ExecutableCommand {
    @Inject
    private AuthMe plugin;
    @Inject
    private Injector injector;
    @Inject
    private Settings settings;
    @Inject
    private DataSource dataSource;
    @Inject
    private CommandService commandService;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        try {
            this.settings.reload();
            ConsoleLogger.setLoggingOptions(this.settings);
            if (!this.settings.getProperty(DatabaseSettings.BACKEND).equals((Object)this.dataSource.getType())) {
                ConsoleLogger.info("Note: cannot change database type during /authme reload");
                sender.sendMessage("Note: cannot change database type during /authme reload");
            }
            this.performReloadOnServices();
            this.commandService.send(sender, MessageKey.CONFIG_RELOAD_SUCCESS);
        }
        catch (Exception e) {
            sender.sendMessage("Error occurred during reload of AuthMe: aborting");
            ConsoleLogger.logException("Aborting! Encountered exception during reload of AuthMe:", e);
            this.plugin.stopOrUnload();
        }
    }

    private void performReloadOnServices() {
        Collection<Reloadable> reloadables = this.injector.retrieveAllOfType(Reloadable.class);
        for (Reloadable reloadable : reloadables) {
            reloadable.reload();
        }
        Collection<SettingsDependent> settingsDependents = this.injector.retrieveAllOfType(SettingsDependent.class);
        for (SettingsDependent dependent : settingsDependents) {
            dependent.reload(this.settings);
        }
    }
}

