/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.limbo.LimboCache;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.ValidationService;
import java.util.List;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class RegisterAdminCommand
implements ExecutableCommand {
    @Inject
    private PasswordSecurity passwordSecurity;
    @Inject
    private CommandService commandService;
    @Inject
    private DataSource dataSource;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private ValidationService validationService;
    @Inject
    private LimboCache limboCache;

    @Override
    public void executeCommand(final CommandSender sender, List<String> arguments) {
        final String playerName = arguments.get(0);
        final String playerPass = arguments.get(1);
        final String playerNameLowerCase = playerName.toLowerCase();
        ValidationService.ValidationResult passwordValidation = this.validationService.validatePassword(playerPass, playerName);
        if (passwordValidation.hasError()) {
            this.commandService.send(sender, passwordValidation.getMessageKey(), passwordValidation.getArgs());
            return;
        }
        this.bukkitService.runTaskOptionallyAsync(new Runnable(){

            @Override
            public void run() {
                if (RegisterAdminCommand.this.dataSource.isAuthAvailable(playerNameLowerCase)) {
                    RegisterAdminCommand.this.commandService.send(sender, MessageKey.NAME_ALREADY_REGISTERED);
                    return;
                }
                HashedPassword hashedPassword = RegisterAdminCommand.this.passwordSecurity.computeHash(playerPass, playerNameLowerCase);
                PlayerAuth auth = PlayerAuth.builder().name(playerNameLowerCase).realName(playerName).password(hashedPassword).build();
                if (!RegisterAdminCommand.this.dataSource.saveAuth(auth)) {
                    RegisterAdminCommand.this.commandService.send(sender, MessageKey.ERROR);
                    return;
                }
                RegisterAdminCommand.this.dataSource.setUnlogged(playerNameLowerCase);
                RegisterAdminCommand.this.commandService.send(sender, MessageKey.REGISTER_SUCCESS);
                ConsoleLogger.info(sender.getName() + " registered " + playerName);
                final Player player = RegisterAdminCommand.this.bukkitService.getPlayerExact(playerName);
                if (player != null) {
                    RegisterAdminCommand.this.bukkitService.scheduleSyncTaskFromOptionallyAsyncTask(new Runnable(){

                        @Override
                        public void run() {
                            RegisterAdminCommand.this.limboCache.restoreData(player);
                            player.kickPlayer(RegisterAdminCommand.this.commandService.retrieveSingle(MessageKey.KICK_FOR_ADMIN_REGISTER));
                        }
                    });
                }
            }
        });
    }
}

