/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.task.purge.PurgeService;
import java.util.Calendar;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class PurgeCommand
implements ExecutableCommand {
    private static final int MINIMUM_LAST_SEEN_DAYS = 30;
    @Inject
    private PurgeService purgeService;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        int days;
        String daysStr = arguments.get(0);
        try {
            days = Integer.parseInt(daysStr);
        }
        catch (NumberFormatException ex) {
            sender.sendMessage(ChatColor.RED + "The value you've entered is invalid!");
            return;
        }
        if (days < 30) {
            sender.sendMessage(ChatColor.RED + "You can only purge data older than " + 30 + " days");
            return;
        }
        boolean includeLastLoginZeroEntries = false;
        if (arguments.size() >= 2) {
            if ("all".equals(arguments.get(1))) {
                includeLastLoginZeroEntries = true;
            } else {
                sender.sendMessage("Purge process aborted; use '/authme purge " + days + " all' to include users with lastlogin = 0");
                return;
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -days);
        long until = calendar.getTimeInMillis();
        this.purgeService.runPurge(sender, until, includeLastLoginZeroEntries);
    }
}

