/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import java.util.Date;
import java.util.List;
import org.bukkit.command.CommandSender;

public class LastLoginCommand
implements ExecutableCommand {
    @Inject
    private DataSource dataSource;
    @Inject
    private CommandService commandService;

    @Override
    public void executeCommand(CommandSender sender, List<String> arguments) {
        String playerName = arguments.size() >= 1 ? arguments.get(0) : sender.getName();
        PlayerAuth auth = this.dataSource.getAuth(playerName);
        if (auth == null) {
            this.commandService.send(sender, MessageKey.USER_NOT_REGISTERED);
            return;
        }
        long lastLogin = auth.getLastLogin();
        long diff = System.currentTimeMillis() - lastLogin;
        String lastLoginMessage = (int)(diff / 86400000L) + " days " + (int)(diff / 3600000L % 24L) + " hours " + (int)(diff / 60000L % 60L) + " mins " + (int)(diff / 1000L % 60L) + " secs";
        Date date = new Date(lastLogin);
        sender.sendMessage("[AuthMe] " + playerName + " last login: " + date.toString());
        sender.sendMessage("[AuthMe] The player " + playerName + " last logged in " + lastLoginMessage + " ago.");
        sender.sendMessage("[AuthMe] Last Player's IP: " + auth.getIp());
    }
}

