/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.converter.Converter;
import fr.xephi.authme.converter.CrazyLoginConverter;
import fr.xephi.authme.converter.MySqlToSqlite;
import fr.xephi.authme.converter.RakamakConverter;
import fr.xephi.authme.converter.RoyalAuthConverter;
import fr.xephi.authme.converter.SqliteToSql;
import fr.xephi.authme.converter.vAuthConverter;
import fr.xephi.authme.converter.xAuthConverter;
import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.util.BukkitService;
import java.util.List;
import java.util.Map;
import org.bukkit.command.CommandSender;

public class ConverterCommand
implements ExecutableCommand {
    @VisibleForTesting
    static final Map<String, Class<? extends Converter>> CONVERTERS = ConverterCommand.getConverters();
    @Inject
    private CommandService commandService;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private Injector injector;

    @Override
    public void executeCommand(final CommandSender sender, List<String> arguments) {
        String job = arguments.get(0);
        Class<? extends Converter> converterClass = CONVERTERS.get(job.toLowerCase());
        if (converterClass == null) {
            sender.sendMessage("[AuthMe] Converter does not exist!");
            return;
        }
        final Converter converter = this.injector.newInstance(converterClass);
        this.bukkitService.runTaskAsynchronously(new Runnable(){

            @Override
            public void run() {
                try {
                    converter.execute(sender);
                }
                catch (Exception e) {
                    ConverterCommand.this.commandService.send(sender, MessageKey.ERROR);
                    ConsoleLogger.logException("Error during conversion:", e);
                }
            }
        });
        sender.sendMessage("[AuthMe] Successfully started " + job);
    }

    private static Map<String, Class<? extends Converter>> getConverters() {
        return ImmutableMap.builder().put((Object)"xauth", xAuthConverter.class).put((Object)"crazylogin", CrazyLoginConverter.class).put((Object)"rakamak", RakamakConverter.class).put((Object)"royalauth", RoyalAuthConverter.class).put((Object)"vauth", vAuthConverter.class).put((Object)"sqlitetosql", SqliteToSql.class).put((Object)"mysqltosqlite", MySqlToSqlite.class).build();
    }
}

