/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.ConsoleLogger;
import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.cache.auth.PlayerCache;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.security.PasswordSecurity;
import fr.xephi.authme.security.crypts.HashedPassword;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.ValidationService;
import java.util.List;
import org.bukkit.command.CommandSender;

public class ChangePasswordAdminCommand
implements ExecutableCommand {
    @Inject
    private PasswordSecurity passwordSecurity;
    @Inject
    private PlayerCache playerCache;
    @Inject
    private DataSource dataSource;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private ValidationService validationService;
    @Inject
    private CommandService commandService;

    @Override
    public void executeCommand(final CommandSender sender, List<String> arguments) {
        String playerName = arguments.get(0);
        final String playerPass = arguments.get(1);
        ValidationService.ValidationResult validationResult = this.validationService.validatePassword(playerPass, playerName);
        if (validationResult.hasError()) {
            this.commandService.send(sender, validationResult.getMessageKey(), validationResult.getArgs());
            return;
        }
        final String playerNameLowerCase = playerName.toLowerCase();
        this.bukkitService.runTaskOptionallyAsync(new Runnable(){

            @Override
            public void run() {
                PlayerAuth auth = null;
                if (ChangePasswordAdminCommand.this.playerCache.isAuthenticated(playerNameLowerCase)) {
                    auth = ChangePasswordAdminCommand.this.playerCache.getAuth(playerNameLowerCase);
                } else if (ChangePasswordAdminCommand.this.dataSource.isAuthAvailable(playerNameLowerCase)) {
                    auth = ChangePasswordAdminCommand.this.dataSource.getAuth(playerNameLowerCase);
                }
                if (auth == null) {
                    ChangePasswordAdminCommand.this.commandService.send(sender, MessageKey.UNKNOWN_USER);
                    return;
                }
                HashedPassword hashedPassword = ChangePasswordAdminCommand.this.passwordSecurity.computeHash(playerPass, playerNameLowerCase);
                auth.setPassword(hashedPassword);
                if (ChangePasswordAdminCommand.this.dataSource.updatePassword(auth)) {
                    ChangePasswordAdminCommand.this.commandService.send(sender, MessageKey.PASSWORD_CHANGED_SUCCESS);
                    ConsoleLogger.info(sender.getName() + " changed password of " + playerNameLowerCase);
                } else {
                    ChangePasswordAdminCommand.this.commandService.send(sender, MessageKey.ERROR);
                }
            }
        });
    }
}

