/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command.executable.authme;

import fr.xephi.authme.cache.auth.PlayerAuth;
import fr.xephi.authme.command.CommandService;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.datasource.DataSource;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.util.BukkitService;
import fr.xephi.authme.util.StringUtils;
import java.util.List;
import org.bukkit.command.CommandSender;

public class AccountsCommand
implements ExecutableCommand {
    @Inject
    private DataSource dataSource;
    @Inject
    private BukkitService bukkitService;
    @Inject
    private CommandService commandService;

    @Override
    public void executeCommand(final CommandSender sender, List<String> arguments) {
        String playerName;
        String string = playerName = arguments.isEmpty() ? sender.getName() : arguments.get(0);
        if (playerName.contains(".")) {
            this.bukkitService.runTaskAsynchronously(new Runnable(){

                @Override
                public void run() {
                    List<String> accountList = AccountsCommand.this.dataSource.getAllAuthsByIp(playerName);
                    if (accountList.isEmpty()) {
                        sender.sendMessage("[AuthMe] This IP does not exist in the database.");
                    } else if (accountList.size() == 1) {
                        sender.sendMessage("[AuthMe] " + playerName + " is a single account player");
                    } else {
                        AccountsCommand.outputAccountsList(sender, playerName, accountList);
                    }
                }
            });
        } else {
            this.bukkitService.runTaskAsynchronously(new Runnable(){

                @Override
                public void run() {
                    PlayerAuth auth = AccountsCommand.this.dataSource.getAuth(playerName.toLowerCase());
                    if (auth == null) {
                        AccountsCommand.this.commandService.send(sender, MessageKey.UNKNOWN_USER);
                        return;
                    }
                    List<String> accountList = AccountsCommand.this.dataSource.getAllAuthsByIp(auth.getIp());
                    if (accountList.isEmpty()) {
                        AccountsCommand.this.commandService.send(sender, MessageKey.USER_NOT_REGISTERED);
                    } else if (accountList.size() == 1) {
                        sender.sendMessage("[AuthMe] " + playerName + " is a single account player");
                    } else {
                        AccountsCommand.outputAccountsList(sender, playerName, accountList);
                    }
                }
            });
        }
    }

    private static void outputAccountsList(CommandSender sender, String playerName, List<String> accountList) {
        sender.sendMessage("[AuthMe] " + playerName + " has " + accountList.size() + " accounts.");
        String message = "[AuthMe] " + StringUtils.join(", ", accountList) + ".";
        sender.sendMessage(message);
    }
}

