/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command;

import com.google.common.collect.Lists;
import fr.xephi.authme.command.CommandArgumentDescription;
import fr.xephi.authme.command.CommandDescription;
import fr.xephi.authme.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public final class CommandUtils {
    private CommandUtils() {
    }

    public static int getMinNumberOfArguments(CommandDescription command) {
        int mandatoryArguments = 0;
        for (CommandArgumentDescription argument : command.getArguments()) {
            if (argument.isOptional()) continue;
            ++mandatoryArguments;
        }
        return mandatoryArguments;
    }

    public static int getMaxNumberOfArguments(CommandDescription command) {
        return command.getArguments().size();
    }

    public static String labelsToString(Iterable<String> labels) {
        return StringUtils.join(" ", labels);
    }

    public static String constructCommandPath(CommandDescription command) {
        StringBuilder sb = new StringBuilder();
        String prefix = "/";
        for (CommandDescription ancestor : CommandUtils.constructParentList(command)) {
            sb.append(prefix).append(ancestor.getLabels().get(0));
            prefix = " ";
        }
        return sb.toString();
    }

    public static List<CommandDescription> constructParentList(CommandDescription command) {
        ArrayList<CommandDescription> commands = new ArrayList<CommandDescription>();
        for (CommandDescription currentCommand = command; currentCommand != null; currentCommand = currentCommand.getParent()) {
            commands.add(currentCommand);
        }
        return Lists.reverse(commands);
    }
}

