/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command;

import fr.xephi.authme.libs.authme.configme.properties.Property;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.output.MessageKey;
import fr.xephi.authme.output.Messages;
import fr.xephi.authme.settings.Settings;
import fr.xephi.authme.util.ValidationService;
import org.bukkit.command.CommandSender;

public class CommandService {
    @Inject
    private Messages messages;
    @Inject
    private Settings settings;
    @Inject
    private ValidationService validationService;

    public void send(CommandSender sender, MessageKey messageKey) {
        this.messages.send(sender, messageKey);
    }

    public void send(CommandSender sender, MessageKey messageKey, String ... replacements) {
        this.messages.send(sender, messageKey, replacements);
    }

    public String[] retrieveMessage(MessageKey key) {
        return this.messages.retrieve(key);
    }

    public String retrieveSingle(MessageKey key) {
        return this.messages.retrieveSingle(key, new String[0]);
    }

    public <T> T getProperty(Property<T> property) {
        return this.settings.getProperty(property);
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean validateEmail(String email) {
        return this.validationService.validateEmail(email);
    }

    public boolean isEmailFreeForRegistration(String email, CommandSender sender) {
        return this.validationService.isEmailFreeForRegistration(email, sender);
    }
}

