/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command;

import fr.xephi.authme.command.CommandDescription;
import fr.xephi.authme.command.CommandInitializer;
import fr.xephi.authme.command.CommandUtils;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.command.FoundCommandResult;
import fr.xephi.authme.command.FoundResultStatus;
import fr.xephi.authme.command.executable.HelpCommand;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.util.CollectionUtils;
import fr.xephi.authme.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.command.CommandSender;

public class CommandMapper {
    private static final Class<? extends ExecutableCommand> HELP_COMMAND_CLASS = HelpCommand.class;
    private final Set<CommandDescription> baseCommands;
    private final PermissionsManager permissionsManager;

    @Inject
    public CommandMapper(CommandInitializer commandInitializer, PermissionsManager permissionsManager) {
        this.baseCommands = commandInitializer.getCommands();
        this.permissionsManager = permissionsManager;
    }

    public FoundCommandResult mapPartsToCommand(CommandSender sender, List<String> parts) {
        if (CollectionUtils.isEmpty(parts)) {
            return new FoundCommandResult(null, parts, null, 0.0, FoundResultStatus.MISSING_BASE_COMMAND);
        }
        CommandDescription base = this.getBaseCommand(parts.get(0));
        if (base == null) {
            return new FoundCommandResult(null, parts, null, 0.0, FoundResultStatus.MISSING_BASE_COMMAND);
        }
        List<String> remainingParts = parts.subList(1, parts.size());
        CommandDescription childCommand = this.getSuitableChild(base, remainingParts);
        if (childCommand != null) {
            FoundResultStatus status = this.getPermissionAwareStatus(sender, childCommand);
            FoundCommandResult result = new FoundCommandResult(childCommand, parts.subList(0, 2), parts.subList(2, parts.size()), 0.0, status);
            return CommandMapper.transformResultForHelp(result);
        }
        if (CommandMapper.hasSuitableArgumentCount(base, remainingParts.size())) {
            FoundResultStatus status = this.getPermissionAwareStatus(sender, base);
            return new FoundCommandResult(base, parts.subList(0, 1), parts.subList(1, parts.size()), 0.0, status);
        }
        return this.getCommandWithSmallestDifference(base, parts);
    }

    public Set<Class<? extends ExecutableCommand>> getCommandClasses() {
        HashSet<Class<? extends ExecutableCommand>> classes = new HashSet<Class<? extends ExecutableCommand>>(50);
        for (CommandDescription command : this.baseCommands) {
            classes.add(command.getExecutableCommand());
            for (CommandDescription child : command.getChildren()) {
                classes.add(child.getExecutableCommand());
            }
        }
        return classes;
    }

    private FoundCommandResult getCommandWithSmallestDifference(CommandDescription base, List<String> parts) {
        if (parts.size() <= 1) {
            return new FoundCommandResult(base, parts, new ArrayList<String>(), 0.0, FoundResultStatus.INCORRECT_ARGUMENTS);
        }
        String childLabel = parts.get(1);
        double minDifference = Double.POSITIVE_INFINITY;
        CommandDescription closestCommand = null;
        for (CommandDescription child : base.getChildren()) {
            double difference = CommandMapper.getLabelDifference(child, childLabel);
            if (!(difference < minDifference)) continue;
            minDifference = difference;
            closestCommand = child;
        }
        if (closestCommand == null) {
            return new FoundCommandResult(base, parts.subList(0, 1), parts.subList(1, parts.size()), 0.0, FoundResultStatus.INCORRECT_ARGUMENTS);
        }
        FoundResultStatus status = minDifference == 0.0 ? FoundResultStatus.INCORRECT_ARGUMENTS : FoundResultStatus.UNKNOWN_LABEL;
        int partsSize = parts.size();
        List<String> labels = parts.subList(0, Math.min(closestCommand.getLabelCount(), partsSize));
        ArrayList<String> arguments = labels.size() == partsSize ? new ArrayList<String>() : parts.subList(labels.size(), partsSize);
        return new FoundCommandResult(closestCommand, labels, arguments, minDifference, status);
    }

    private CommandDescription getBaseCommand(String label) {
        String baseLabel = label.toLowerCase();
        for (CommandDescription command : this.baseCommands) {
            if (!command.hasLabel(baseLabel)) continue;
            return command;
        }
        return null;
    }

    private CommandDescription getSuitableChild(CommandDescription baseCommand, List<String> parts) {
        if (CollectionUtils.isEmpty(parts)) {
            return null;
        }
        String label = parts.get(0).toLowerCase();
        int argumentCount = parts.size() - 1;
        for (CommandDescription child : baseCommand.getChildren()) {
            if (!child.hasLabel(label) || !CommandMapper.hasSuitableArgumentCount(child, argumentCount)) continue;
            return child;
        }
        return null;
    }

    private static FoundCommandResult transformResultForHelp(FoundCommandResult result) {
        if (result.getCommandDescription() != null && HELP_COMMAND_CLASS == result.getCommandDescription().getExecutableCommand()) {
            ArrayList<String> arguments = new ArrayList<String>(result.getArguments());
            arguments.add(0, result.getLabels().get(0));
            return new FoundCommandResult(result.getCommandDescription(), result.getLabels(), arguments, result.getDifference(), result.getResultStatus());
        }
        return result;
    }

    private FoundResultStatus getPermissionAwareStatus(CommandSender sender, CommandDescription command) {
        if (sender != null && !this.permissionsManager.hasPermission(sender, command.getPermission())) {
            return FoundResultStatus.NO_PERMISSION;
        }
        return FoundResultStatus.SUCCESS;
    }

    private static boolean hasSuitableArgumentCount(CommandDescription command, int argumentCount) {
        int minArgs = CommandUtils.getMinNumberOfArguments(command);
        int maxArgs = CommandUtils.getMaxNumberOfArguments(command);
        return argumentCount >= minArgs && argumentCount <= maxArgs;
    }

    private static double getLabelDifference(CommandDescription command, String givenLabel) {
        double minDifference = Double.POSITIVE_INFINITY;
        for (String commandLabel : command.getLabels()) {
            double difference = StringUtils.getDifference(commandLabel, givenLabel);
            if (!(difference < minDifference)) continue;
            minDifference = difference;
        }
        return minDifference;
    }
}

