/*
 * Decompiled with CFR 0.152.
 */
package fr.xephi.authme.command;

import fr.xephi.authme.AuthMe;
import fr.xephi.authme.command.CommandDescription;
import fr.xephi.authme.command.CommandMapper;
import fr.xephi.authme.command.CommandUtils;
import fr.xephi.authme.command.ExecutableCommand;
import fr.xephi.authme.command.FoundCommandResult;
import fr.xephi.authme.command.FoundResultStatus;
import fr.xephi.authme.command.help.HelpProvider;
import fr.xephi.authme.libs.jalu.injector.Injector;
import fr.xephi.authme.libs.javax.inject.Inject;
import fr.xephi.authme.permission.PermissionsManager;
import fr.xephi.authme.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class CommandHandler {
    private static final double SUGGEST_COMMAND_THRESHOLD = 0.75;
    private final CommandMapper commandMapper;
    private final PermissionsManager permissionsManager;
    private final HelpProvider helpProvider;
    private Map<Class<? extends ExecutableCommand>, ExecutableCommand> commands = new HashMap<Class<? extends ExecutableCommand>, ExecutableCommand>();

    @Inject
    public CommandHandler(Injector injector, CommandMapper commandMapper, PermissionsManager permissionsManager, HelpProvider helpProvider) {
        this.commandMapper = commandMapper;
        this.permissionsManager = permissionsManager;
        this.helpProvider = helpProvider;
        this.initializeCommands(injector, commandMapper.getCommandClasses());
    }

    public boolean processCommand(CommandSender sender, String bukkitCommandLabel, String[] bukkitArgs) {
        List<String> parts = CommandHandler.skipEmptyArguments(bukkitArgs);
        parts.add(0, bukkitCommandLabel);
        FoundCommandResult result = this.commandMapper.mapPartsToCommand(sender, parts);
        this.handleCommandResult(sender, result);
        return !FoundResultStatus.MISSING_BASE_COMMAND.equals((Object)result.getResultStatus());
    }

    private void handleCommandResult(CommandSender sender, FoundCommandResult result) {
        switch (result.getResultStatus()) {
            case SUCCESS: {
                this.executeCommand(sender, result);
                break;
            }
            case MISSING_BASE_COMMAND: {
                sender.sendMessage(ChatColor.DARK_RED + "Failed to parse " + AuthMe.getPluginName() + " command!");
                break;
            }
            case INCORRECT_ARGUMENTS: {
                this.sendImproperArgumentsMessage(sender, result);
                break;
            }
            case UNKNOWN_LABEL: {
                CommandHandler.sendUnknownCommandMessage(sender, result);
                break;
            }
            case NO_PERMISSION: {
                CommandHandler.sendPermissionDeniedError(sender);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown result status '" + (Object)((Object)result.getResultStatus()) + "'");
            }
        }
    }

    private void initializeCommands(Injector injector, Set<Class<? extends ExecutableCommand>> commandClasses) {
        for (Class<? extends ExecutableCommand> clazz : commandClasses) {
            this.commands.put(clazz, injector.newInstance(clazz));
        }
    }

    private void executeCommand(CommandSender sender, FoundCommandResult result) {
        ExecutableCommand executableCommand = this.commands.get(result.getCommandDescription().getExecutableCommand());
        List<String> arguments = result.getArguments();
        executableCommand.executeCommand(sender, arguments);
    }

    private static List<String> skipEmptyArguments(String[] args) {
        ArrayList<String> cleanArguments = new ArrayList<String>();
        for (String argument : args) {
            if (StringUtils.isEmpty(argument)) continue;
            cleanArguments.add(argument);
        }
        return cleanArguments;
    }

    private static void sendUnknownCommandMessage(CommandSender sender, FoundCommandResult result) {
        sender.sendMessage(ChatColor.DARK_RED + "Unknown command!");
        if (result.getDifference() <= 0.75 && result.getCommandDescription() != null) {
            sender.sendMessage(ChatColor.YELLOW + "Did you mean " + ChatColor.GOLD + CommandUtils.constructCommandPath(result.getCommandDescription()) + ChatColor.YELLOW + "?");
        }
        sender.sendMessage(ChatColor.YELLOW + "Use the command " + ChatColor.GOLD + "/" + result.getLabels().get(0) + " help" + ChatColor.YELLOW + " to view help.");
    }

    private void sendImproperArgumentsMessage(CommandSender sender, FoundCommandResult result) {
        CommandDescription command = result.getCommandDescription();
        if (!this.permissionsManager.hasPermission(sender, command.getPermission())) {
            CommandHandler.sendPermissionDeniedError(sender);
            return;
        }
        sender.sendMessage(ChatColor.DARK_RED + "Incorrect command arguments!");
        this.helpProvider.outputHelp(sender, result, 4);
        List<String> labels = result.getLabels();
        String childLabel = labels.size() >= 2 ? labels.get(1) : "";
        sender.sendMessage(ChatColor.GOLD + "Detailed help: " + ChatColor.WHITE + "/" + labels.get(0) + " help " + childLabel);
    }

    private static void sendPermissionDeniedError(CommandSender sender) {
        sender.sendMessage(ChatColor.DARK_RED + "You don't have permission to use this command!");
    }
}

